/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectionI;
import Ice.FeatureNotSupportedException;
import Ice.LocalException;
import Ice.ObjectAdapter;
import IceInternal.Connector;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.RouterInfo;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import IceUtil.Assert;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public final class OutgoingConnectionFactory {
    private final Instance _instance;
    private boolean _destroyed;
    private HashMap _connections = new HashMap();
    private HashSet _pending = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized void destroy() {
        if (this._destroyed) {
            return;
        }
        Iterator p = this._connections.values().iterator();
        while (p.hasNext()) {
            LinkedList connectionList = (LinkedList)p.next();
            Iterator q = connectionList.iterator();
            while (q.hasNext()) {
                ConnectionI connection = (ConnectionI)q.next();
                connection.destroy(1);
            }
        }
        this._destroyed = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        HashMap connections;
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            while (!this._destroyed || !this._pending.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            connections = this._connections;
            this._connections = null;
        }
        Iterator p = connections.values().iterator();
        while (p.hasNext()) {
            LinkedList connectionList = (LinkedList)p.next();
            Iterator q = connectionList.iterator();
            while (q.hasNext()) {
                ConnectionI connection = (ConnectionI)q.next();
                connection.waitUntilFinished();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionI create(EndpointI[] endpts, boolean hasMore, boolean threadPerConnection, BooleanHolder compress) {
        int i;
        if (!$assertionsDisabled && endpts.length <= 0) {
            throw new AssertionError();
        }
        EndpointI[] endpoints = new EndpointI[endpts.length];
        System.arraycopy(endpts, 0, endpoints, 0, endpts.length);
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            for (int i2 = 0; i2 < endpoints.length; ++i2) {
                if (threadPerConnection || !endpoints[i2].requiresThreadPerConnection()) continue;
                FeatureNotSupportedException ex = new FeatureNotSupportedException();
                ex.unsupportedFeature = "endpoint requires thread-per-connection:\n" + endpoints[i2].toString();
                throw ex;
            }
            Iterator p = this._connections.values().iterator();
            while (p.hasNext()) {
                LinkedList connectionList = (LinkedList)p.next();
                Iterator q = connectionList.iterator();
                while (q.hasNext()) {
                    ConnectionI con = (ConnectionI)q.next();
                    if (!con.isFinished()) continue;
                    q.remove();
                }
                if (!connectionList.isEmpty()) continue;
                p.remove();
            }
            for (i = 0; i < endpoints.length; ++i) {
                if (defaultsAndOverrides.overrideTimeout) {
                    endpoints[i] = endpoints[i].timeout(defaultsAndOverrides.overrideTimeoutValue);
                }
                endpoints[i] = endpoints[i].compress(false);
            }
            for (i = 0; i < endpoints.length; ++i) {
                LinkedList connectionList = (LinkedList)this._connections.get(endpoints[i]);
                if (connectionList == null) continue;
                Iterator q = connectionList.iterator();
                while (q.hasNext()) {
                    ConnectionI connection = (ConnectionI)q.next();
                    if (connection.isDestroyed() || connection.threadPerConnection() != threadPerConnection) continue;
                    compress.value = defaultsAndOverrides.overrideCompress ? defaultsAndOverrides.overrideCompressValue : endpts[i].compress();
                    return connection;
                }
            }
            boolean searchAgain = false;
            while (!this._destroyed) {
                int i3;
                for (i3 = 0; i3 < endpoints.length && !this._pending.contains(endpoints[i3]); ++i3) {
                }
                if (i3 == endpoints.length) break;
                searchAgain = true;
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            if (searchAgain) {
                for (int i4 = 0; i4 < endpoints.length; ++i4) {
                    LinkedList connectionList = (LinkedList)this._connections.get(endpoints[i4]);
                    if (connectionList == null) continue;
                    Iterator q = connectionList.iterator();
                    while (q.hasNext()) {
                        ConnectionI connection = (ConnectionI)q.next();
                        if (connection.isDestroyed() || connection.threadPerConnection() != threadPerConnection) continue;
                        compress.value = defaultsAndOverrides.overrideCompress ? defaultsAndOverrides.overrideCompressValue : endpts[i4].compress();
                        return connection;
                    }
                }
            }
            for (int i5 = 0; i5 < endpoints.length; ++i5) {
                this._pending.add(endpoints[i5]);
            }
        }
        ConnectionI connection = null;
        LocalException exception = null;
        for (i = 0; i < endpoints.length; ++i) {
            EndpointI endpoint = endpoints[i];
            try {
                Transceiver transceiver = endpoint.clientTransceiver();
                if (transceiver == null) {
                    Connector connector = endpoint.connector();
                    if (!$assertionsDisabled && connector == null) {
                        throw new AssertionError();
                    }
                    int timeout = defaultsAndOverrides.overrideConnectTimeout ? defaultsAndOverrides.overrideConnectTimeoutValue : endpoint.timeout();
                    transceiver = connector.connect(timeout);
                    if (!$assertionsDisabled && transceiver == null) {
                        throw new AssertionError();
                    }
                }
                connection = new ConnectionI(this._instance, transceiver, endpoint, null, threadPerConnection);
                connection.start();
                connection.validate();
                if (defaultsAndOverrides.overrideCompress) {
                    compress.value = defaultsAndOverrides.overrideCompressValue;
                    break;
                }
                compress.value = endpts[i].compress();
                break;
            }
            catch (LocalException ex) {
                exception = ex;
                if (connection != null) {
                    connection.waitUntilFinished();
                    connection = null;
                }
                TraceLevels traceLevels = this._instance.traceLevels();
                if (traceLevels.retry < 2) continue;
                StringBuffer s = new StringBuffer();
                s.append("connection to endpoint failed");
                if (hasMore || i < endpoints.length - 1) {
                    s.append(", trying next endpoint\n");
                } else {
                    s.append(" and no more endpoints to try\n");
                }
                s.append(exception.toString());
                this._instance.initializationData().logger.trace(traceLevels.retryCat, s.toString());
                continue;
            }
        }
        OutgoingConnectionFactory outgoingConnectionFactory2 = this;
        synchronized (outgoingConnectionFactory2) {
            for (int i6 = 0; i6 < endpoints.length; ++i6) {
                this._pending.remove(endpoints[i6]);
            }
            this.notifyAll();
            if (connection == null) {
                if (!$assertionsDisabled && exception == null) {
                    throw new AssertionError();
                }
                throw exception;
            }
            LinkedList<ConnectionI> connectionList = (LinkedList<ConnectionI>)this._connections.get(connection.endpoint());
            if (connectionList == null) {
                connectionList = new LinkedList<ConnectionI>();
                this._connections.put(connection.endpoint(), connectionList);
            }
            connectionList.add(connection);
            if (this._destroyed) {
                connection.destroy(1);
                throw new CommunicatorDestroyedException();
            }
            connection.activate();
        }
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        return connection;
    }

    public synchronized void setRouterInfo(RouterInfo routerInfo) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        if (!$assertionsDisabled && routerInfo == null) {
            throw new AssertionError();
        }
        ObjectAdapter adapter = routerInfo.getAdapter();
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        EndpointI[] endpoints = routerInfo.getClientEndpoints();
        for (int i = 0; i < endpoints.length; ++i) {
            EndpointI endpoint = endpoints[i];
            if (defaultsAndOverrides.overrideTimeout) {
                endpoint = endpoint.timeout(defaultsAndOverrides.overrideTimeoutValue);
            }
            endpoint = endpoint.compress(false);
            LinkedList connectionList = (LinkedList)this._connections.get(endpoints[i]);
            if (connectionList == null) continue;
            Iterator p = connectionList.iterator();
            while (p.hasNext()) {
                ConnectionI connection = (ConnectionI)p.next();
                try {
                    connection.setAdapter(adapter);
                }
                catch (LocalException ex) {}
            }
        }
    }

    public synchronized void removeAdapter(ObjectAdapter adapter) {
        if (this._destroyed) {
            return;
        }
        Iterator p = this._connections.values().iterator();
        while (p.hasNext()) {
            LinkedList connectionList = (LinkedList)p.next();
            Iterator q = connectionList.iterator();
            while (q.hasNext()) {
                ConnectionI connection = (ConnectionI)q.next();
                if (connection.getAdapter() != adapter) continue;
                try {
                    connection.setAdapter(null);
                }
                catch (LocalException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        LinkedList c = new LinkedList();
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            Iterator p = this._connections.values().iterator();
            while (p.hasNext()) {
                LinkedList connectionList = (LinkedList)p.next();
                Iterator q = connectionList.iterator();
                while (q.hasNext()) {
                    c.add(q.next());
                }
            }
        }
        Iterator p = c.iterator();
        while (p.hasNext()) {
            ConnectionI conn = (ConnectionI)p.next();
            try {
                conn.flushBatchRequests();
            }
            catch (LocalException ex) {}
        }
    }

    OutgoingConnectionFactory(Instance instance) {
        this._instance = instance;
        this._destroyed = false;
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._destroyed);
        Assert.FinalizerAssert(this._connections == null);
        super.finalize();
    }

    static {
        $assertionsDisabled = !OutgoingConnectionFactory.class.desiredAssertionStatus();
    }
}

