/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.ConnectionI;
import Freeze.DatabaseException;
import Freeze.DeadlockException;
import Freeze.Transaction;
import Ice.LocalObjectImpl;

class TransactionI
extends LocalObjectImpl
implements Transaction {
    private ConnectionI _connection;
    private int _txTrace;
    private com.sleepycat.db.Transaction _txn;
    private String _errorPrefix;

    public void commit() {
        String txnId = null;
        try {
            block8: {
                try {
                    this._connection.closeAllIterators();
                    if (this._txTrace >= 1) {
                        txnId = Long.toHexString((long)(this._txn.getId() & Integer.MAX_VALUE) + 0x80000000L);
                    }
                    this._txn.commit();
                    if (this._txTrace < 1) break block8;
                    this._connection.communicator().getLogger().trace("Freeze.Map", this._errorPrefix + "committed transaction " + txnId);
                }
                catch (com.sleepycat.db.DeadlockException e) {
                    if (this._txTrace >= 1) {
                        this._connection.communicator().getLogger().trace("Freeze.Map", this._errorPrefix + "failed to commit transaction " + txnId + ": " + e.getMessage());
                    }
                    DeadlockException ex = new DeadlockException();
                    ex.initCause(e);
                    ex.message = this._errorPrefix + "DbTxn.commit: " + e.getMessage();
                    throw ex;
                }
                catch (com.sleepycat.db.DatabaseException e) {
                    if (this._txTrace >= 1) {
                        this._connection.communicator().getLogger().trace("Freeze.Map", this._errorPrefix + "failed to commit transaction " + txnId + ": " + e.getMessage());
                    }
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(e);
                    ex.message = this._errorPrefix + "DbTxn.commit: " + e.getMessage();
                    throw ex;
                }
            }
            Object var5_2 = null;
            this._connection.clearTransaction();
            this._connection = null;
            this._txn = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            this._connection.clearTransaction();
            this._connection = null;
            this._txn = null;
            throw throwable;
        }
    }

    public void rollback() {
        String txnId = null;
        try {
            block8: {
                try {
                    this._connection.closeAllIterators();
                    if (this._txTrace >= 1) {
                        txnId = Long.toHexString((long)(this._txn.getId() & Integer.MAX_VALUE) + 0x80000000L);
                    }
                    this._txn.abort();
                    if (this._txTrace < 1) break block8;
                    this._connection.communicator().getLogger().trace("Freeze.Map", this._errorPrefix + "rolled back transaction " + txnId);
                }
                catch (com.sleepycat.db.DeadlockException e) {
                    if (this._txTrace >= 1) {
                        this._connection.communicator().getLogger().trace("Freeze.Map", this._errorPrefix + "failed to rollback transaction " + txnId + ": " + e.getMessage());
                    }
                    DeadlockException ex = new DeadlockException();
                    ex.initCause(e);
                    ex.message = this._errorPrefix + "DbTxn.abort: " + e.getMessage();
                    throw ex;
                }
                catch (com.sleepycat.db.DatabaseException e) {
                    if (this._txTrace >= 1) {
                        this._connection.communicator().getLogger().trace("Freeze.Map", this._errorPrefix + "failed to rollback transaction " + txnId + ": " + e.getMessage());
                    }
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(e);
                    ex.message = this._errorPrefix + "DbTxn.abort: " + e.getMessage();
                    throw ex;
                }
            }
            Object var5_2 = null;
            this._connection.clearTransaction();
            this._connection = null;
            this._txn = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            this._connection.clearTransaction();
            this._connection = null;
            this._txn = null;
            throw throwable;
        }
    }

    TransactionI(ConnectionI connection) {
        this._connection = connection;
        this._txTrace = connection.txTrace();
        this._errorPrefix = "Freeze DB DbEnv(\"" + this._connection.envName() + "\"): ";
        try {
            this._txn = this._connection.dbEnv().getEnv().beginTransaction(null, null);
            if (this._txTrace >= 1) {
                String txnId = Long.toHexString((long)(this._txn.getId() & Integer.MAX_VALUE) + 0x80000000L);
                this._connection.communicator().getLogger().trace("Freeze.Map", this._errorPrefix + "started transaction " + txnId);
            }
        }
        catch (com.sleepycat.db.DatabaseException e) {
            if (this._txTrace >= 1) {
                this._connection.communicator().getLogger().trace("Freeze.Map", this._errorPrefix + "failed to start transaction: " + e.getMessage());
            }
            DatabaseException ex = new DatabaseException();
            ex.initCause(e);
            ex.message = this._errorPrefix + "txn_begin: " + e.getMessage();
            throw ex;
        }
    }

    com.sleepycat.db.Transaction dbTxn() {
        return this._txn;
    }
}

