/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.LocalObjectImpl;
import Ice.MarshalException;
import Ice.MemoryLimitException;
import Ice.NegativeSizeException;
import Ice.ObjectPrx;
import Ice.SyscallException;
import Ice.UnmarshalOutOfBoundsException;
import Ice.UnsupportedEncodingException;
import Ice.UserException;
import IceInternal.ByteBuffer;
import IceInternal.Instance;
import IceInternal.UserExceptionFactory;
import IceUtil.Arrays;
import java.util.Hashtable;

public class BasicStream {
    private Instance _instance;
    private ByteBuffer _buf;
    private int _capacity;
    private int _limit;
    private byte[] _stringBytes;
    private char[] _stringChars;
    private ReadEncaps _readEncapsStack;
    private WriteEncaps _writeEncapsStack;
    private int _readSlice;
    private int _writeSlice;
    private int _messageSizeMax;
    private int _shrinkCounter;
    SeqData _seqDataStack;
    private static Hashtable _exceptionFactories = new Hashtable();
    private static Object _factoryMutex = new Object();

    public BasicStream(Instance instance) {
        this._instance = instance;
        this.allocate(1500);
        this._capacity = this._buf.capacity();
        this._limit = 0;
        this._readEncapsStack = null;
        this._writeEncapsStack = null;
        this._messageSizeMax = this._instance.messageSizeMax();
        this._seqDataStack = null;
        this._shrinkCounter = 0;
    }

    public void reset() {
        if (this._limit > 0 && this._limit * 2 < this._capacity) {
            if (++this._shrinkCounter > 2) {
                this.allocate(this._limit);
                this._capacity = this._buf.capacity();
                this._shrinkCounter = 0;
            }
        } else {
            this._shrinkCounter = 0;
        }
        this._limit = 0;
        this._buf.limit(this._capacity);
        this._buf.position(0);
        this._readEncapsStack = null;
    }

    public Instance instance() {
        return this._instance;
    }

    public void swap(BasicStream basicStream) {
        ByteBuffer byteBuffer = basicStream._buf;
        basicStream._buf = this._buf;
        this._buf = byteBuffer;
        int n = basicStream._capacity;
        basicStream._capacity = this._capacity;
        this._capacity = n;
        int n2 = basicStream._limit;
        basicStream._limit = this._limit;
        this._limit = n2;
        ReadEncaps readEncaps = basicStream._readEncapsStack;
        basicStream._readEncapsStack = this._readEncapsStack;
        this._readEncapsStack = readEncaps;
        WriteEncaps writeEncaps = basicStream._writeEncapsStack;
        basicStream._writeEncapsStack = this._writeEncapsStack;
        this._writeEncapsStack = writeEncaps;
        int n3 = basicStream._readSlice;
        basicStream._readSlice = this._readSlice;
        this._readSlice = n3;
        int n4 = basicStream._writeSlice;
        basicStream._writeSlice = this._writeSlice;
        this._writeSlice = n4;
        SeqData seqData = basicStream._seqDataStack;
        basicStream._seqDataStack = this._seqDataStack;
        this._seqDataStack = seqData;
        int n5 = basicStream._shrinkCounter;
        basicStream._shrinkCounter = this._shrinkCounter;
        this._shrinkCounter = n5;
    }

    public void resize(int n, boolean bl) {
        if (n > this._messageSizeMax) {
            throw new MemoryLimitException();
        }
        if (n > this._capacity) {
            int n2 = this._capacity << 1;
            int n3 = n2 > n ? n2 : n;
            this._buf.limit(this._limit);
            this.reallocate(n3);
            this._capacity = this._buf.capacity();
        }
        if (bl) {
            this._buf.limit(n);
        } else {
            this._buf.limit(this._capacity);
        }
        this._buf.position(n);
        this._limit = n;
    }

    public ByteBuffer prepareRead() {
        return this._buf;
    }

    public ByteBuffer prepareWrite() {
        this._buf.limit(this._limit);
        this._buf.position(0);
        return this._buf;
    }

    public void startSeq(int n, int n2) {
        if (n == 0) {
            return;
        }
        SeqData seqData = new SeqData(n, n2);
        seqData.previous = this._seqDataStack;
        this._seqDataStack = seqData;
        int n3 = this._buf.remaining();
        if (this._seqDataStack.previous == null) {
            if (n * n2 > n3) {
                throw new UnmarshalOutOfBoundsException();
            }
        } else {
            this.checkSeq(n3);
        }
    }

    public void checkSeq() {
        this.checkSeq(this._buf.remaining());
    }

    public void checkSeq(int n) {
        int n2 = 0;
        SeqData seqData = this._seqDataStack;
        do {
            n2 += (seqData.numElements - 1) * seqData.minSize;
        } while ((seqData = seqData.previous) != null);
        if (n2 > n) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void endSeq(int n) {
        if (n == 0) {
            return;
        }
        SeqData seqData = this._seqDataStack;
        this._seqDataStack = seqData.previous;
    }

    public void endElement() {
        --this._seqDataStack.numElements;
    }

    public void startWriteEncaps() {
        WriteEncaps writeEncaps = new WriteEncaps();
        writeEncaps.next = this._writeEncapsStack;
        this._writeEncapsStack = writeEncaps;
        this._writeEncapsStack.start = this._buf.position();
        this.writeInt(0);
        this.writeByte((byte)1);
        this.writeByte((byte)0);
    }

    public void endWriteEncaps() {
        int n = this._writeEncapsStack.start;
        int n2 = this._buf.position() - n;
        this._buf.putInt(n, n2);
        this._writeEncapsStack = this._writeEncapsStack.next;
    }

    public void startReadEncaps() {
        ReadEncaps readEncaps = new ReadEncaps();
        readEncaps.next = this._readEncapsStack;
        this._readEncapsStack = readEncaps;
        this._readEncapsStack.start = this._buf.position();
        int n = this.readInt();
        if (n < 0) {
            throw new NegativeSizeException();
        }
        if (n - 4 > this._buf.limit()) {
            throw new UnmarshalOutOfBoundsException();
        }
        this._readEncapsStack.sz = n;
        int n2 = this.readByte();
        int n3 = this.readByte();
        if (n2 != 1 || n3 > 0) {
            UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException();
            unsupportedEncodingException.badMajor = n2 < 0 ? n2 + 256 : n2;
            unsupportedEncodingException.badMinor = n3 < 0 ? n3 + 256 : n3;
            unsupportedEncodingException.major = 1;
            unsupportedEncodingException.minor = 0;
            throw unsupportedEncodingException;
        }
        this._readEncapsStack.encodingMajor = n2;
        this._readEncapsStack.encodingMinor = n3;
    }

    public void endReadEncaps() {
        int n = this._readEncapsStack.start;
        int n2 = this._readEncapsStack.sz;
        try {
            this._buf.position(n + n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnmarshalOutOfBoundsException();
        }
        this._readEncapsStack = this._readEncapsStack.next;
    }

    public int getReadEncapsSize() {
        return this._readEncapsStack.sz - 6;
    }

    public void skipEncaps() {
        int n = this.readInt();
        if (n < 0) {
            throw new NegativeSizeException();
        }
        try {
            this._buf.position(this._buf.position() + n - 4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void startWriteSlice() {
        this.writeInt(0);
        this._writeSlice = this._buf.position();
    }

    public void endWriteSlice() {
        int n = this._buf.position() - this._writeSlice + 4;
        this._buf.putInt(this._writeSlice - 4, n);
    }

    public void startReadSlice() {
        int n = this.readInt();
        if (n < 0) {
            throw new NegativeSizeException();
        }
        this._readSlice = this._buf.position();
    }

    public void endReadSlice() {
    }

    public void skipSlice() {
        int n = this.readInt();
        if (n < 0) {
            throw new NegativeSizeException();
        }
        try {
            this._buf.position(this._buf.position() + n - 4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeSize(int n) {
        if (n > 254) {
            this.expand(5);
            this._buf.put((byte)-1);
            this._buf.putInt(n);
        } else {
            this.expand(1);
            this._buf.put((byte)n);
        }
    }

    public int readSize() {
        try {
            int n = this._buf.get();
            if (n == -1) {
                int n2 = this._buf.getInt();
                if (n2 < 0) {
                    throw new NegativeSizeException();
                }
                return n2;
            }
            return n < 0 ? n + 256 : n;
        }
        catch (ByteBuffer.UnderflowException underflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeBlob(byte[] byArray) {
        this.expand(byArray.length);
        this._buf.put(byArray);
    }

    public byte[] readBlob(int n) {
        byte[] byArray = new byte[n];
        try {
            this._buf.get(byArray);
            return byArray;
        }
        catch (ByteBuffer.UnderflowException underflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeByte(byte by) {
        this.expand(1);
        this._buf.put(by);
    }

    public byte readByte() {
        try {
            return this._buf.get();
        }
        catch (ByteBuffer.UnderflowException underflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeBool(boolean bl) {
        this.expand(1);
        this._buf.put(bl ? (byte)1 : 0);
    }

    public boolean readBool() {
        try {
            return this._buf.get() == 1;
        }
        catch (ByteBuffer.UnderflowException underflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeShort(short s) {
        this.expand(2);
        this._buf.putShort(s);
    }

    public short readShort() {
        try {
            return this._buf.getShort();
        }
        catch (ByteBuffer.UnderflowException underflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeInt(int n) {
        this.expand(4);
        this._buf.putInt(n);
    }

    public int readInt() {
        try {
            return this._buf.getInt();
        }
        catch (ByteBuffer.UnderflowException underflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeString(String string) {
        if (string == null) {
            this.writeSize(0);
        } else {
            int n = string.length();
            if (n > 0) {
                byte[] byArray = string.getBytes();
                this.writeSize(byArray.length);
                this.expand(byArray.length);
                this._buf.put(byArray);
            } else {
                this.writeSize(0);
            }
        }
    }

    public void writeStringSeq(String[] stringArray) {
        if (stringArray == null) {
            this.writeSize(0);
        } else {
            this.writeSize(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.writeString(stringArray[i]);
            }
        }
    }

    public String readString() {
        int n = this.readSize();
        if (n == 0) {
            return "";
        }
        try {
            if (this._stringBytes == null || n > this._stringBytes.length) {
                this._stringBytes = new byte[n];
                this._stringChars = new char[n];
            }
            this._buf.get(this._stringBytes, 0, n);
            for (int i = 0; i < n; ++i) {
                if (this._stringBytes[i] < 0) {
                    return new String(this._stringBytes, 0, n);
                }
                this._stringChars[i] = (char)this._stringBytes[i];
            }
            return new String(this._stringChars, 0, n);
        }
        catch (ByteBuffer.UnderflowException underflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public String[] readStringSeq() {
        int n = this.readSize();
        this.startSeq(n, 1);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.readString();
            this.checkSeq();
            this.endElement();
        }
        this.endSeq(n);
        return stringArray;
    }

    public void writeProxy(ObjectPrx objectPrx) {
        this._instance.proxyFactory().proxyToStream(objectPrx, this);
    }

    public ObjectPrx readProxy() {
        return this._instance.proxyFactory().streamToProxy(this);
    }

    public void writeUserException(UserException userException) {
        this.writeBool(false);
        userException.__write(this);
    }

    public void throwException() throws UserException {
        boolean bl = this.readBool();
        String string = this.readString();
        while (true) {
            UserExceptionFactory userExceptionFactory;
            if ((userExceptionFactory = this.getUserExceptionFactory(string)) != null) {
                try {
                    userExceptionFactory.createAndThrow();
                }
                catch (UserException userException) {
                    userException.__read(this, false);
                    throw userException;
                }
            }
            this.skipSlice();
            string = this.readString();
        }
    }

    public int pos() {
        return this._buf.position();
    }

    public void pos(int n) {
        this._buf.position(n);
    }

    public int size() {
        return this._limit;
    }

    public boolean isEmpty() {
        return this._limit == 0;
    }

    private void expand(int n) {
        if (this._buf.position() == this._limit) {
            int n2 = this._limit;
            this._limit += n;
            if (this._limit > this._messageSizeMax) {
                throw new MemoryLimitException();
            }
            if (this._limit > this._capacity) {
                int n3 = this._capacity << 1;
                int n4 = n3 > this._limit ? n3 : this._limit;
                this._buf.limit(n2);
                int n5 = this._buf.position();
                this._buf.position(0);
                this.reallocate(n4);
                this._capacity = this._buf.capacity();
                this._buf.limit(this._capacity);
                this._buf.position(n5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserExceptionFactory getUserExceptionFactory(String string) {
        UserExceptionFactory userExceptionFactory = null;
        Object object = _factoryMutex;
        synchronized (object) {
            userExceptionFactory = (UserExceptionFactory)_exceptionFactories.get(string);
        }
        if (userExceptionFactory == null) {
            object = this.findClass(string);
            if (object != null) {
                userExceptionFactory = new DynamicUserExceptionFactory((Class)object);
            }
            if (userExceptionFactory != null) {
                Object object2 = _factoryMutex;
                synchronized (object2) {
                    _exceptionFactories.put(string, userExceptionFactory);
                }
            }
        }
        return userExceptionFactory;
    }

    private Class findClass(String string) {
        String string2;
        int n;
        Class clazz = null;
        String string3 = this.typeToClass(string);
        clazz = this.getConcreteClass(string3);
        if (clazz == null && (n = string.indexOf(58, 2)) != -1) {
            String string4 = string.substring(2, n);
            String string5 = this._instance.properties().getProperty("Ice.Package." + string4);
            if (string5.length() > 0) {
                clazz = this.getConcreteClass(string5 + "." + string3);
            }
        }
        if (clazz == null && (string2 = this._instance.properties().getProperty("Ice.Default.Package")).length() > 0) {
            clazz = this.getConcreteClass(string2 + "." + string3);
        }
        return clazz;
    }

    private Class getConcreteClass(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!clazz.isInterface()) {
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private static String fixKwd(String string) {
        Object[] objectArray = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "checkedCast", "class", "clone", "const", "continue", "default", "do", "double", "else", "equals", "extends", "false", "final", "finalize", "finally", "float", "for", "getClass", "goto", "hashCode", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "notify", "notifyAll", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "toString", "transient", "true", "try", "uncheckedCast", "void", "volatile", "wait", "while"};
        boolean bl = Arrays.search(objectArray, string) >= 0;
        return bl ? "_" + string : string;
    }

    private String typeToClass(String string) {
        if (!string.startsWith("::")) {
            throw new MarshalException();
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 2;
        boolean bl = false;
        while (!bl) {
            String string2;
            int n2 = string.indexOf(58, n);
            if (n2 != -1) {
                string2 = string.substring(n, n2);
                n = n2 + 2;
            } else {
                string2 = string.substring(n);
                bl = true;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(BasicStream.fixKwd(string2));
        }
        return stringBuffer.toString();
    }

    private void allocate(int n) {
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = ByteBuffer.allocate(n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MarshalException marshalException = new MarshalException();
            marshalException.reason = "OutOfMemoryError occurred while allocating a ByteBuffer";
            marshalException.initCause(outOfMemoryError);
            throw marshalException;
        }
        byteBuffer.order(1);
        this._buf = byteBuffer;
    }

    private void reallocate(int n) {
        ByteBuffer byteBuffer = this._buf;
        this.allocate(n);
        byteBuffer.position(0);
        this._buf.put(byteBuffer);
    }

    private static final class SeqData {
        public int numElements;
        public int minSize;
        public SeqData previous;

        public SeqData(int n, int n2) {
            this.numElements = n;
            this.minSize = n2;
        }
    }

    private static final class WriteEncaps {
        int start;
        WriteEncaps next;

        private WriteEncaps() {
        }
    }

    private static final class ReadEncaps {
        int start;
        int sz;
        byte encodingMajor;
        byte encodingMinor;
        ReadEncaps next;

        private ReadEncaps() {
        }
    }

    private static final class DynamicUserExceptionFactory
    extends LocalObjectImpl
    implements UserExceptionFactory {
        private Class _class;

        DynamicUserExceptionFactory(Class clazz) {
            this._class = clazz;
        }

        public void createAndThrow() throws UserException {
            try {
                throw (UserException)this._class.newInstance();
            }
            catch (UserException userException) {
                throw userException;
            }
            catch (Exception exception) {
                SyscallException syscallException = new SyscallException();
                syscallException.initCause(exception);
                throw syscallException;
            }
        }
    }
}

