/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.Identity;
import Ice.Object;
import Ice.Util;
import IceInternal.Instance;
import IceUtil.StringUtil;
import java.util.Hashtable;

public final class ServantManager {
    private Instance _instance;
    private final String _adapterName;
    private Hashtable _servantMapMap = new Hashtable();

    public synchronized void addServant(Object object, Identity identity, String string) {
        Hashtable<String, Object> hashtable;
        if (string == null) {
            string = "";
        }
        if ((hashtable = (Hashtable<String, Object>)this._servantMapMap.get(identity)) == null) {
            hashtable = new Hashtable<String, Object>();
            this._servantMapMap.put(identity, hashtable);
        } else if (hashtable.containsKey(string)) {
            AlreadyRegisteredException alreadyRegisteredException = new AlreadyRegisteredException();
            alreadyRegisteredException.id = Util.identityToString(identity);
            alreadyRegisteredException.kindOfObject = "servant";
            if (string.length() > 0) {
                alreadyRegisteredException.id = alreadyRegisteredException.id + " -f " + StringUtil.escapeString(string, "");
            }
            throw alreadyRegisteredException;
        }
        hashtable.put(string, object);
    }

    public synchronized Object findServant(Identity identity, String string) {
        if (string == null) {
            string = "";
        }
        Hashtable hashtable = (Hashtable)this._servantMapMap.get(identity);
        Object object = null;
        if (hashtable != null) {
            object = (Object)hashtable.get(string);
        }
        return object;
    }

    public synchronized boolean hasServant(Identity identity) {
        Hashtable hashtable = (Hashtable)this._servantMapMap.get(identity);
        return hashtable != null;
    }

    public ServantManager(Instance instance, String string) {
        this._instance = instance;
        this._adapterName = string;
    }

    public synchronized void destroy() {
        this._servantMapMap.clear();
        this._instance = null;
    }
}

