/*____________________________________________________________________________

    Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

    Portions Copyright (C) 1999 EMusic.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: fileselector.cpp,v 1.9 2003/09/16 17:35:29 kgk Exp $
____________________________________________________________________________*/


#include <unistd.h>
#include <dirent.h>
#include <string>
#include <vector>
#ifdef __QNX__
#include <strings.h>
#endif
using namespace std;
#include "config.h"
#include "fileselector.h"
#include "utility.h"
#include "preferences.h"

#if defined(solaris)                                                          
#include <sys/types.h>                                                        
#include <sys/param.h>  /* for MAXPATHLEN */                                  
#include <sys/stat.h>                                                         
#endif                                                                        

extern char old_path[PATH_MAX];

FileSelector::FileSelector(FAContext *context,const char *windowtitle)
{
    m_context = context;
    title = windowtitle;
    returnpath = "";
    extended = true;
    ok = false;
    done = false;
}

gboolean filesel_destroy(GtkWidget *widget, gpointer p)
{
    bool runmain = (bool)p;
    if (runmain)
        gtk_main_quit();
    return FALSE;
}

void ok_internal(GtkWidget *widget, FileSelector *p)
{
    p->AddEvent();
}

void cancel_internal(GtkWidget *widget, FileSelector *p)
{
    p->CancelEvent();
}

string recursive_path(char subdirs[PATH_MAX], string returnpath,int *sub_rnum)
{
    DIR *dir=NULL;
    struct dirent *current=NULL;
#if defined(solaris)
    struct stat *s;
#endif
    if ((dir = opendir(subdirs))!=NULL){
        current = readdir(dir);
        current = readdir(dir);
        while((current=readdir(dir))!=NULL){
#if defined(solaris)
	stat(subdirs, s);
        if (s->st_mode & S_IFDIR) {
#else
            if(current->d_type==DT_DIR){
#endif
		char temp_subdir[PATH_MAX];
		strncpy(temp_subdir, subdirs,PATH_MAX);
		strcat(temp_subdir,"/");
		strncat(temp_subdir,current->d_name,FILENAME_MAX);
		returnpath = recursive_path(temp_subdir,returnpath,sub_rnum);
	    }
	    else {
    	    returnpath += "\n";
	    returnpath += subdirs;
	    returnpath += "/";
	    returnpath += current->d_name;
	    sub_rnum++;
	    }
	}
    }
    closedir(dir);
    return (returnpath);
}

void FileSelector::CancelEvent()
{
    gtk_widget_destroy(filesel);
    ok = false;
    done = true;
}

void FileSelector::AddEvent()
{
  //FIXME: OOPS, I deleted half this function before I figured out
  //what it meant...  maybe it was important ?

    GtkFileSelection *gfile = GTK_FILE_SELECTION(filesel);
    char *raw_path = NULL;
    gchar **row=gtk_file_selection_get_selections(gfile);
    gint rownum = 0;
    gint sub_rnum = 0;

    char *rawtext = (char*)gtk_entry_get_text(GTK_ENTRY(gfile->selection_entry));
    if (!strncasecmp("http://", rawtext, 7) ||
        !strncasecmp("rtp://", rawtext, 6)) {
        returnpath = strdup_new(rawtext);
	g_strfreev(row);
        gtk_widget_destroy(GTK_WIDGET(gfile));
        ok = true;
        done = true;
        return;
    }

    returnpath=row[rownum];
    rownum++;

    if(row[rownum]){
	while (row[rownum]) {
	  returnpath += "\n";
	  returnpath += row[rownum];
	  rownum++;
	}
    }

    g_strfreev(row);
    gtk_widget_destroy(GTK_WIDGET(gfile));

    ok = true;
    done = true;
    //    m_context->prefs->SetPrefString(kLastDirPref, old_path);
}

bool FileSelector::Run(bool runMain)
{
    bool dummyBool;
    int32_t dummyInt;
    if (!runMain)
        gdk_threads_enter();

    filesel = gtk_file_selection_new(title.c_str());
    m_context->prefs->GetPrefBoolean(kSetLastResumePref, &dummyBool);
    dummyInt = PATH_MAX;
    if(dummyBool){
	string old2_path = old_path;
	m_context->prefs->GetPrefString(kLastDirPref, &old2_path);
	strncpy(old_path, old2_path.c_str(),PATH_MAX);
	gtk_file_selection_set_filename (GTK_FILE_SELECTION (filesel), old_path);
    }
    else
	m_context->prefs->SetPrefString(kLastDirPref,string("/"));
    gtk_window_set_modal(GTK_WINDOW(filesel), TRUE);
    gtk_signal_connect(GTK_OBJECT(filesel), "destroy",
                       GTK_SIGNAL_FUNC(filesel_destroy), (gpointer)runMain);
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button),
                       "clicked", GTK_SIGNAL_FUNC(cancel_internal), this);
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
                       "clicked", GTK_SIGNAL_FUNC(ok_internal), this);
     if (extended)
       gtk_file_selection_set_select_multiple(GTK_FILE_SELECTION(filesel),TRUE);
    gtk_widget_show(filesel);

    if (runMain)
        gtk_main();
    else {
        gdk_threads_leave();
        while (!done)
            usleep(20);
    }

    if (ok)
       return true;
    return false;
}

/* arch-tag: d28f61b0-4fe8-480d-9c0d-359c6acb0d05
   (do not change this comment) */
