##############################################################################
#
# Copyright (c) 2001, 2002 Zope Corporation and Contributors.
# All Rights Reserved.
# 
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
# 
##############################################################################
"""
Revision information:
$Id: Retrievers.py,v 1.1 2002/06/08 19:28:12 chrism Exp $
"""
import string
import urllib2
from ZPublisher.mapply import mapply
from ZPublisher.Publish import call_object, missing_name, dont_publish_class

class ZODBRetriever:
   def __init__(self, context):
      self.context = context

   def __call__(self, path):
      ob = self.context.restrictedTraverse(path)
      REQUEST = self.context.REQUEST
      result = mapply(ob, REQUEST.args, REQUEST,
                      call_object, 1,
                      missing_name,
                      dont_publish_class,
                      REQUEST, bind=1)
      return result

class ZODBImageRetriever:
   def __init__(self, context):
      self.context = context

   def __call__(self, path):
      image = self.context.restrictedTraverse(path)
      # need to stringify in case it's "pdata"
      height = image.height or None
      width = image.width or None
      return str(image.data), width, height

class HTTPRetriever:
    def __call__(self, url):
        if url[:7] != 'http://':
            if url[:8] != 'https://':
                raise ValueError, 'local files cannot be obtained: %s' % url
        self.url = string.strip(url)
        data = urllib2.urlopen(self.url)
        return data.read()
    
