##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
ZAttachmentAttribute product
"""


from config import *
import os
import string

from Products.ZAttachmentAttribute import ZAttachmentAttribute
from Products.ZAttachmentAttribute import ZAttachmentRegistry
from Products.ZAttachmentAttribute import ZAbstractAttachment
from Products.ZAttachmentAttribute.Log import *

class MSAccessAttachment(ZAbstractAttachment.ZAbstractAttachment):
    """
    Access file abstraction
    """
    
    icon_file = "access.gif"
    small_icon_file = "access_small.gif"
    content_types = ('application/msaccess', 'application/vnd.ms-access', )
    index_list = ()


    def indexAttachment(self):
        """
        indexAttachment(self) => nothing
        No indexing is done on access for the instant
        """
        raise RuntimeError, "Unable to index this"



    def isPreviewAvailable(self,):
        return 0


    def convertPreview(self,):
        return None


ZAttachmentRegistry.AttachmentRegistry.registerClass(MSAccessAttachment, globals())

