from Products.PortalTransforms.interfaces import itransform
from Products.CMFCore.utils import format_stx

DEFAULT_STX_LEVEL = 1

try:
    from App.config import getConfiguration
except ImportError:
    STX_LEVEL = DEFAULT_STX_LEVEL
else:
    try:
        STX_LEVEL = getConfiguration().structured_text_header_level or DEFAULT_STX_LEVEL
    except AttributeError:
        STX_LEVEL = DEFAULT_STX_LEVEL

class st:
    __implements__ = itransform

    __name__ = "st_to_html"
    inputs   = ("text/structured",)
    output   = "text/html"

    def name(self):
        return self.__name__

    def convert(self, orig, data, level=None, **kwargs):
        if level is None:
            level = STX_LEVEL
        data.setData(format_stx(text=orig, level=level))
        return data

def register():
    return st()
