/****************************************************************************
**
** Copyright (C) 2003-2006 Tilo Riemer <riemer@crossvc.com>,
**                         Frank Hemer <frank@hemer.org>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include <qobject.h>

//----------------------------------------------------------------------------

#include "TextCodec.h"

//----------------------------------------------------------------------------

namespace TextCodec {
   const char Latin1[] = "Latin1";
   const char Big5[] = "Big5";
   const char Big5_HKSCS[] = "Big5-HKSCS";
   const char eucJP[] = "eucJP";
   const char eucKR[] = "eucKR";
   const char GB2312[] = "GB2312";
   const char GBK[] = "GBK";
   const char GB18030[] = "GB18030";
   const char JIS7[] = "JIS7";
   const char Shift_JIS[] = "Shift-JIS";
   const char TSCII[] = "TSCII";
   const char utf8[] = "utf8";
   const char utf16[] = "utf16";
   const char KOI8_R[] = "KOI8-R";
   const char KOI8_U[] = "KOI8-U";
   const char ISO8859_1[] = "ISO8859-1";
   const char ISO8859_2[] = "ISO8859-2";
   const char ISO8859_3[] = "ISO8859-3";
   const char ISO8859_4[] = "ISO8859-4";
   const char ISO8859_5[] = "ISO8859-5";
   const char ISO8859_6[] = "ISO8859-6";
   const char ISO8859_7[] = "ISO8859-7";
   const char ISO8859_8[] = "ISO8859-8";
   const char ISO8859_8_i[] = "ISO8859-8-i";
   const char ISO8859_9[] = "ISO8859-9";
   const char ISO8859_10[] = "ISO8859-10";
   const char ISO8859_13[] = "ISO8859-13";
   const char ISO8859_14[] = "ISO8859-14";
   const char ISO8859_15[] = "ISO8859-15";
   const char IBM_850[] = "IBM 850";
   const char IBM_866[] = "IBM 866";
   const char CP874[] = "CP874";
   const char CP1250[] = "CP1250";
   const char CP1251[] = "CP1251";
   const char CP1252[] = "CP1252";
   const char CP1253[] = "CP1253";
   const char CP1254[] = "CP1254";
   const char CP1255[] = "CP1255";
   const char CP1256[] = "CP1256";
   const char CP1257[] = "CP1257";
   const char CP1258[] = "CP1258";
   const char Apple_Roman[] = "Apple Roman";
   const char TIS_620[] = "TIS-620";
};

//----------------------------------------------------------------------------

CTextCodecPool::CTextCodecPool()
{
   m_codecDict.setAutoDelete(true);
   m_supportedCodecs.setAutoDelete(true);
   initSupportedCodecs();   
}
   
//----------------------------------------------------------------------------

void CTextCodecPool::addDefaultCodec()
{
   addCodecForName(TextCodec::DEFAULT_CODEC);
}

//----------------------------------------------------------------------------

void CTextCodecPool::addCodecForLocale()
{
   QTextCodec *pCodec = QTextCodec::codecForLocale();
   if (!pCodec) throw XCreateCodecFailed();  //throw an exception if creation of codec failed
   if (!m_codecDict.find(pCodec->name())) m_codecDict.insert(pCodec->name(), pCodec);
   m_nameOfCodecForLocale = pCodec->name();
}

//----------------------------------------------------------------------------

void CTextCodecPool::addCodecForName(const char* name)
{
   QTextCodec *pCodec;
   
   //what is to do to generate codecs for Chinese, Japanese and friends?
   //if (strcmp(name, TextCodec::Big5)) pCodec = QBig5Codec
   
   pCodec = QTextCodec::codecForName(name);
   if (!pCodec) throw XCreateCodecFailed();  //throw an exception if creation of codec failed
   if (!m_codecDict.find(name)) m_codecDict.insert(name, pCodec);
}

//----------------------------------------------------------------------------

QTextCodec* CTextCodecPool::pDefaultCodec()
{
   return m_codecDict.find(TextCodec::DEFAULT_CODEC);
}

//----------------------------------------------------------------------------

QTextCodec* CTextCodecPool::pCodecForLocale()
{
   return m_codecDict.find(m_nameOfCodecForLocale);
}

//----------------------------------------------------------------------------

QTextCodec* CTextCodecPool::pCodecForName(const char* name)
{
   return m_codecDict.find(name);
}

//----------------------------------------------------------------------------

void CTextCodecPool::initSupportedCodecs()
{
   TextCodec::SCodec *pCodec;

   m_supportedCodecs.resize(43);
   
   pCodec = new TextCodec::SCodec(TextCodec::Latin1, QObject::tr(""));
   m_supportedCodecs.insert(0, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::Big5, QObject::tr("Chinese"));
   m_supportedCodecs.insert(1, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::Big5_HKSCS, QObject::tr("Chinese"));
   m_supportedCodecs.insert(2, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::eucJP, QObject::tr("Japanese"));
   m_supportedCodecs.insert(3, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::eucKR, QObject::tr("Korean"));
   m_supportedCodecs.insert(4, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::GB2312, QObject::tr("Chinese"));
   m_supportedCodecs.insert(5, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::GBK, QObject::tr("Chinese"));
   m_supportedCodecs.insert(6, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::GB18030, QObject::tr("Chinese"));
   m_supportedCodecs.insert(7, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::JIS7, QObject::tr("Japanese"));
   m_supportedCodecs.insert(8, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::Shift_JIS, QObject::tr("Japanese"));
   m_supportedCodecs.insert(9, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::TSCII, QObject::tr("Tamil"));
   m_supportedCodecs.insert(10, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::utf8, QObject::tr("Unicode, 8-bit"));
   m_supportedCodecs.insert(11, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::utf16, QObject::tr("Unicode"));
   m_supportedCodecs.insert(12, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::KOI8_R, QObject::tr("Russian"));
   m_supportedCodecs.insert(13, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::KOI8_U, QObject::tr("Ukrainian"));
   m_supportedCodecs.insert(14, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_1, QObject::tr("Western"));
   m_supportedCodecs.insert(15, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_2, QObject::tr("Central European"));
   m_supportedCodecs.insert(16, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_3, QObject::tr("Central European"));
   m_supportedCodecs.insert(17, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_4, QObject::tr("Baltic"));
   m_supportedCodecs.insert(18, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_5, QObject::tr("Cyrillic"));
   m_supportedCodecs.insert(19, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_6, QObject::tr("Arabic"));
   m_supportedCodecs.insert(20, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_7, QObject::tr("Greek"));
   m_supportedCodecs.insert(21, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_8, QObject::tr("Hebrew, visually ordered"));
   m_supportedCodecs.insert(22, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_8_i, QObject::tr("Hebrew, logically ordered"));
   m_supportedCodecs.insert(23, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_9, QObject::tr("Turkish"));
   m_supportedCodecs.insert(24, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_10, "");
   m_supportedCodecs.insert(25, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_13, "");
   m_supportedCodecs.insert(26, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_14, "");
   m_supportedCodecs.insert(27, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::ISO8859_15, QObject::tr("Western"));
   m_supportedCodecs.insert(28, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::IBM_850, "");
   m_supportedCodecs.insert(29, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::IBM_866, "");
   m_supportedCodecs.insert(30, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::CP874, "");
   m_supportedCodecs.insert(31, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::CP1250, QObject::tr("Central European"));
   m_supportedCodecs.insert(32, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::CP1251, QObject::tr("Cyrillic"));
   m_supportedCodecs.insert(33, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::CP1252, QObject::tr("Western"));
   m_supportedCodecs.insert(34, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::CP1253, QObject::tr("Greek"));
   m_supportedCodecs.insert(35, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::CP1254, QObject::tr("Turkish"));
   m_supportedCodecs.insert(36, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::CP1255, QObject::tr("Hebrew"));
   m_supportedCodecs.insert(37, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::CP1256, QObject::tr("Arabic"));
   m_supportedCodecs.insert(38, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::CP1257, QObject::tr("Baltic"));
   m_supportedCodecs.insert(39, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::CP1258, "");
   m_supportedCodecs.insert(40, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::Apple_Roman, "");
   m_supportedCodecs.insert(41, pCodec);
   pCodec = new TextCodec::SCodec(TextCodec::TIS_620, QObject::tr("Thai"));
   m_supportedCodecs.insert(42, pCodec);
}

//----------------------------------------------------------------------------

