/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListSearchable
extends Searchable
implements ListDataListener,
PropertyChangeListener {
    public ListSearchable(JList jList) {
        super(jList);
        jList.getModel().addListDataListener(this);
        jList.addPropertyChangeListener("model", this);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JList) {
            ((JList)this._component).getModel().removeListDataListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    protected void setSelectedIndex(int n, boolean bl) {
        if (bl) {
            ((JList)this._component).addSelectionInterval(n, n);
        } else if (((JList)this._component).getSelectedIndex() != n) {
            ((JList)this._component).setSelectedIndex(n);
        }
        ((JList)this._component).ensureIndexIsVisible(n);
    }

    protected int getSelectedIndex() {
        return ((JList)this._component).getSelectedIndex();
    }

    protected Object getElementAt(int n) {
        ListModel listModel = ((JList)this._component).getModel();
        return listModel.getElementAt(n);
    }

    protected int getElementCount() {
        ListModel listModel = ((JList)this._component).getModel();
        return listModel.getSize();
    }

    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        if (listDataEvent.getIndex0() == -1 && listDataEvent.getIndex1() == -1) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            ListModel listModel;
            this.hidePopup();
            ListModel listModel2 = (ListModel)propertyChangeEvent.getOldValue();
            if (listModel2 != null) {
                listModel2.removeListDataListener(this);
            }
            if ((listModel = (ListModel)propertyChangeEvent.getNewValue()) != null) {
                listModel.addListDataListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }
}

