/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BamFileIoUtils;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.List;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;

public class GatherBamFiles
extends CommandLineProgram {
    @Usage
    public final String USAGE = "Concatenates one or more BAM files together as efficiently as possible. Assumes that the list of BAM files provided as INPUT are in the order that they should be concatenated and simply concatenates the bodies of the BAM files while retaining the header from the first file.  Operates via copying of the gzip blocks directly for speed but also supports generation of an MD5 on the output and indexing of the output BAM file. Only support BAM files, does not support SAM files.";
    @Option(shortName="I", doc="One or more BAM files or text files containing lists of BAM files one per line.")
    public List<File> INPUT;
    @Option(shortName="O", doc="The output BAM file to write.")
    public File OUTPUT;
    private static final Log log = Log.getInstance(GatherBamFiles.class);

    public static void main(String[] args) {
        GatherBamFiles gatherer = new GatherBamFiles();
        gatherer.CREATE_INDEX = true;
        gatherer.instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        List inputs = IOUtil.unrollFiles(this.INPUT, (String[])new String[]{".bam", ".sam"});
        for (File f : inputs) {
            IOUtil.assertFileIsReadable((File)f);
        }
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.determineBlockCopyingStatus(inputs)) {
            BamFileIoUtils.gatherWithBlockCopying((List)inputs, (File)this.OUTPUT, (boolean)this.CREATE_INDEX, (boolean)this.CREATE_MD5_FILE);
        } else {
            GatherBamFiles.gatherNormally(inputs, this.OUTPUT, this.CREATE_INDEX, this.CREATE_MD5_FILE);
        }
        return 0;
    }

    private boolean determineBlockCopyingStatus(List<File> inputs) {
        boolean useBlockCopying = true;
        for (File f : inputs) {
            if (BamFileIoUtils.isBamFile((File)f)) continue;
            useBlockCopying = false;
        }
        return useBlockCopying;
    }

    private static void gatherNormally(List<File> inputs, File output, boolean createIndex, boolean createMd5) {
        SAMFileReader tmp = new SAMFileReader(inputs.get(0));
        SAMFileHeader header = tmp.getFileHeader();
        tmp.close();
        SAMFileWriter out = new SAMFileWriterFactory().setCreateIndex(createIndex).setCreateMd5File(createMd5).makeSAMOrBAMWriter(header, true, output);
        for (File f : inputs) {
            log.info(new Object[]{"Gathering " + f.getAbsolutePath()});
            SAMFileReader in = new SAMFileReader(f);
            for (SAMRecord rec : in) {
                out.addAlignment(rec);
            }
            CloserUtil.close((Object)in);
        }
        out.close();
    }
}

