/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Routine:
  int FLhomeDir (const char User[], char Home[])

Purpose:
  Get the home directory for a user

Description:
  This routine returns the path name corresponding to the home directory for a
  user.  When the User argument is empty, the current user is assumed.  In that
  case, the translation of the environment variable HOME is used if possible.
  In other cases, the home directory is taken from the password entry for the
  user.  If the user is unknown, the home directory string is returned as
  "~User".

Parameters:
  <-  int FLhomeDir
      Number of characters in the output string
   -> const char User[]
      Input character string specifying the user.  If this string is empty, the
      current user is used.
  <-  char Home[]
      Output string with the home directory.  Except for the case of the root
      directory "/", the directory name does not have a trailing '/' character.
      This string is at most FILENAME_MAX characters long including the
      terminating null character.

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.20 $  $Date: 1997/10/14 14:37:20 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLhomeDir.c 1.20 1997/10/14 libtsp-v3r0 $";

#include <stdlib.h>		/* getenv prototype */
#include <string.h>

#include <libtsp.h>
#include <libtsp/Xstdio.h>	/* FILENAME_MAX */
#include <libtsp/sysOS.h>

#ifdef MSDOS
#  ifndef unix
#    define MSDOS_SEP
#  endif
#endif

#ifndef MSDOS_SEP
#  define PWD_HOME
#endif

#ifdef PWD_HOME
#  include <pwd.h>	/* struct passwd, getpwnam prototype */
#  include <unistd.h>	/* getuid definitions */
#endif

#ifdef MSDOS_SEP
#  define DIR_SEP_CHAR		'\\'
#else
#  define DIR_SEP_CHAR		'/'
#endif


int
FLhomeDir (User, Home)

     const char User[];
     char Home[];

{
  char *h, *p;
  int n, nc;
#ifdef PWD_HOME
  struct passwd *pwd;
#endif

  h = NULL;
  if (User[0] == '\0') {

/* No user name specified */
    /* Try the environment variable HOME */
    p = getenv ("HOME");
    if (p != NULL && *p != '\0')
      h = p;
#ifdef PWD_HOME
    /* Try the password entry */
    else {
      pwd = getpwuid (getuid ());
      if (pwd != NULL)
	h = pwd->pw_dir;
    }
#endif
  }

#ifdef PWD_HOME
  else {

/* User specified, try the password entry */
    pwd = getpwnam (User);
    if (pwd != NULL)
      h = pwd->pw_dir;
  }
#endif

  if (h != NULL) {

/* Found a home directory */
    nc = strlen (h);
    if (nc > 1 && h[nc-1] == DIR_SEP_CHAR)
      --nc;
    n = STcopyNMax (h, Home, nc, FILENAME_MAX-1);
  }

  else {

/* Unsuccessful */
    Home[0] = '~';
    n = STcopyMax (User, &Home[1], FILENAME_MAX-2);
    n = n + 1;
  }

  return n;
}
