/*
 *   mwmclss2.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
/*****************************************************************************/
/* The routines in this module handle the command parsing for the Class 2    */
/* Fax specific AT Commands.                                                 */
/*                                                                           */
/* mwmClss2Command is called from mwmCmdParseATcmd when a '+' is encountered */
/* in the AT Command string.                                                 */
/* It attempts to parse the string into a fax specific routine.  If it is    */
/* successful, it calls the appropriate Fax routine.  If not, it moves the   */
/* pointer back to just after the '+' and returns MWM_ATCMD_ERROR            */
/*****************************************************************************/
#include <mwmparse.h>
#include <mwmparsi.h>

#include <unistd.h>

static char szThisFile[] = "mwmclss2.c";

USHORT  mwmClss2FAACommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FAACommand entry\n");
  if ( (psi->usNextPPIndex + PP_FAA_CMD_SPACE) < PP_BUFFER_THRESHOLD)
  {
     usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                    &psi->usNextATIndex);

     if (usParm == 1)
     {
       usParserStatus = MWM_ATCMD_ERROR;
     }
     else
     if (usParm == 0)
     {
//       psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x104 | psi->usParserMode;
//       psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
     }
     else
       usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FAACommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}





USHORT  mwmClss2FBORCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FBOCommand entry\n");
  if ( (psi->usNextPPIndex + PP_FBOR_CMD_SPACE) < PP_BUFFER_THRESHOLD)
  {
     usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                    &psi->usNextATIndex);

     if ((usParm<2))
     {
//       psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x105 | psi->usParserMode;
       psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x10;
       psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0E;
       psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
     }
     else
       usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FBOCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}




USHORT  mwmClss2FBUFCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  char   *achString = "1024";

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FBUFCommand entry\n");

  if ( (psi->usNextPPIndex + strlen(achString)) < PP_BUFFER_THRESHOLD)
  {
    usParserStatus = mwmParseEchoString(psi,achString);
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FBUFCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


USHORT  mwmClss2FCRCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FCRCommand entry\n");
  usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                      &psi->usNextATIndex);

  if ((usParm == 0) || (usParm == 1)) {
    psi->Class2Capabilities.usFCR = usParm;

    /**************************************************************
    ** If the T30 task is already loaded, write the new values
    ** to its storage.
    ***************************************************************/
    usParserStatus = mwmClss2WriteTaskData( psi,
                                            psi->dsp.dspaddrCAPBUFF+FCR_OFFSET,
                                            &psi->Class2Capabilities.usFCR,
                                            1,
                                            szThisFile, __LINE__);
  } else {
    usParserStatus = MWM_ATCMD_ERROR;
  } /* endif */
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FCRCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmClss2FSPLCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FSPL entry\n");
  usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                      &psi->usNextATIndex);

  if ((usParm == 0) || (usParm == 1)) {
    psi->Class2Capabilities.usFSPL = usParm;

    /**************************************************************
    ** If the T30 task is already loaded, write the new values
    ** to its storage.
    ***************************************************************/
    usParserStatus = mwmClss2WriteTaskData( psi,
                                            psi->dsp.dspaddrCAPBUFF+FSPL_OFFSET,
                                            &psi->Class2Capabilities.usFSPL,
                                            1,
                                            szThisFile, __LINE__);
  } else {
    usParserStatus = MWM_ATCMD_ERROR;
  } /* endif */
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FSPLCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmClss2FLPLCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FLPLCommand entry\n");
  usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                      &psi->usNextATIndex);

  if ((usParm == 0) || (usParm == 1)) {
    psi->Class2Capabilities.usFLPL = usParm;

    /**************************************************************
    ** If the T30 task is already loaded, write the new values
    ** to its storage.
    ***************************************************************/
    usParserStatus = mwmClss2WriteTaskData( psi,
                                            psi->dsp.dspaddrCAPBUFF+FLPL_OFFSET,
                                            &psi->Class2Capabilities.usFLPL,
                                            1,
                                            szThisFile, __LINE__);
  } else {
    usParserStatus = MWM_ATCMD_ERROR;
  } /* endif */
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FLPLCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmClss2FPTSCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FPTSCommand entry\n");
  usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                      &psi->usNextATIndex);

  if ((usParm >= 1) && (usParm <= 5)) {
    psi->Class2Capabilities.usFPTS = usParm;

    /**************************************************************
    ** If the T30 task is already loaded, write the new values
    ** to its storage.
    ***************************************************************/
    usParserStatus = mwmClss2WriteTaskData( psi,
                                            psi->dsp.dspaddrCAPBUFF+FPTS_OFFSET,
                                            &psi->Class2Capabilities.usFPTS,
                                            1,
                                            szThisFile, __LINE__);
  } else {
    usParserStatus = MWM_ATCMD_ERROR;
  } /* endif */
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FPTSCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmClss2FCQCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FCQCommand entry\n");
  usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                      &psi->usNextATIndex);

  if ((usParm == 0) || (usParm == 1)) {
    psi->Class2Capabilities.usFCQ = usParm;

    /**************************************************************
    ** If the T30 task is already loaded, write the new values
    ** to its storage.
    ***************************************************************/
    usParserStatus = mwmClss2WriteTaskData( psi,
                                            psi->dsp.dspaddrCAPBUFF+FCQ_OFFSET,
                                            &psi->Class2Capabilities.usFCQ,
                                            1,
                                            szThisFile, __LINE__);
  } else {
    usParserStatus = MWM_ATCMD_ERROR;
  } /* endif */
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FCQCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmClss2FMINSPCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FMINSPCommand entry\n");
  usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                      &psi->usNextATIndex);

  if ((usParm >= 0) && 
      (usParm <= 3)) {
    psi->Class2Capabilities.usFMINSP = usParm;

    /**************************************************************
    ** If the T30 task is already loaded, write the new values
    ** to its storage.
    ***************************************************************/
    usParserStatus = mwmClss2WriteTaskData( psi,
                                            psi->dsp.dspaddrCAPBUFF+FMINSP_OFFSET,
                                            &psi->Class2Capabilities.usFMINSP,
                                            1,
                                            szThisFile, __LINE__);
  } else {
    usParserStatus = MWM_ATCMD_ERROR;
  } /* endif */
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FMINSPCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


USHORT  mwmClss2FDCCCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParmNumber = 0;
  USHORT usParm;


//char   achDebugString[30] = "\0";
  char   achCapabilities[] = "(0,1),(0-5),(0),(0-2),(0),(0),(0),(0-7)";
  char   achString[AT_CMD_BUFFER_SIZE];
  char   *achParm;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FDCCCommand entry\n");
  /***************************************************************************/
  /* 10/11/94                                                                */
  /* Before we try to handle the list of parameters, look to see if the      */
  /* first parm is a '?'.  If so, this command is querying the capabilities  */
  /* rather than setting them...                                             */
  /***************************************************************************/
  if (psi->achCommandBuffer[psi->usNextATIndex] == '?')
  {
    psi->usNextATIndex++;
    usParserStatus = mwmParseEchoString(psi,achCapabilities);
    return usParserStatus;
  }

  /***************************************************************************/
  /* Do the parsing work before we ever write anything to the PP command     */
  /* buffer.                                                                 */
  /***************************************************************************/

  /****************************************************************************/
  /* At this point, the pointer is just past the =                           */
  /* We should be at the beginning of the parameter list.                    */
  /* Copy the rest of the AT command buffer string to a temporary buffer     */
  /***************************************************************************/
  strcpy(achString,&psi->achCommandBuffer[psi->usNextATIndex]);

  /***************************************************************************/
  /* Split this string apart into parameters with strtok.                    */
  /***************************************************************************/
  achParm = mwmParseGetNextArgument( achString, &usParmNumber );
  while (achParm != NULL)
  {

//    sscanf(achParm, "%u", &usParm);
    usParm = atoi(achParm);
    DPF("Parameter %u = %u",usParmNumber,usParm);

    if (strlen(achParm))
    {
      /*********************************************************************/
      /* If there is a value at all, it is always 1 character long.        */
      /* We will do some funky ascii                                       */
      /* subtraction to get the value.                                     */
      /*********************************************************************/
//      usParm = ((char)*achParm - (char)'0');

      /*********************************************************************/
      /* Check to see if this is a valid parameter.                        */
      /* These Parameters are listed in Table 8.4 of the                   */
      /* "Asynchronous Facsimile DCE Control Standard" Dated 8/20/90       */
      /* We don't allow all of the values listed in that table.            */
      /* switch statement identifies which parameters we accept as valid   */
      /*********************************************************************/
      switch (usParmNumber)
      {
        case 0:
          /*****************************************************************/
          /* Vertical Resolution.                                          */
          /*****************************************************************/
          switch (usParm) {
            case 0:
              psi->Class2Capabilities.usVR = 0;
            break;
            case 1:
              psi->Class2Capabilities.usVR = 2;
            break;
            default:
              return MWM_ATCMD_ERROR;
          } /* endswitch */
        break;

        case 1:
          /*****************************************************************/
          /* Bit Rate                                                      */
          /*****************************************************************/
          switch (usParm) {
            case 0:
            case 1:
            case 2:
            case 3:
              psi->Class2Capabilities.usBR = usParm;
            break;
            case 4:
              psi->Class2Capabilities.usBR = 6;
            break;
            case 5:
              psi->Class2Capabilities.usBR = 7;
            break;
            default:
              return MWM_ATCMD_ERROR;
          } /* endswitch */
        break;

        case 2:
          /*****************************************************************/
          /* Page Width                                                    */
          /*****************************************************************/
          switch (usParm) {
            case 0:
            case 1:
            case 2:
              psi->Class2Capabilities.usWD = usParm;
            break;
            default:
              return MWM_ATCMD_ERROR;
          } /* endswitch */
        break;

        case 3:
          /*****************************************************************/
          /* Page Length                                                   */
          /*****************************************************************/
          switch (usParm) {
            case 0:
            case 1:
            case 2:
              psi->Class2Capabilities.usLN = usParm;
            break;
            default:
              return MWM_ATCMD_ERROR;
          } /* endswitch */
        break;

        case 4:
          /*****************************************************************/
          /* Data Compression Format                                       */
          /*****************************************************************/
          if (usParm > 0) {
            return MWM_ATCMD_ERROR;
          } else {
            psi->Class2Capabilities.usDF = usParm;
          } /* endif */
        break;

        case 5:
          /*****************************************************************/
          /* Error Correction                                              */
          /*****************************************************************/
          if (usParm > 0) {
            return MWM_ATCMD_ERROR;
          } else {
            psi->Class2Capabilities.usEC = usParm;
          } /* endif */
        break;

        case 6:
          /*****************************************************************/
          /* BFT                                                           */
          /*****************************************************************/
          if (usParm > 0) {
            return MWM_ATCMD_ERROR;
          } else {
            psi->Class2Capabilities.usBF = usParm;
          } /* endif */
        break;

        case 7:
          /*****************************************************************/
          /* Scan Time/Line                                                */
          /* Currently, we allow this parameter to be up to 7, but we      */
          /* don't do anything with it.                                    */
          /*****************************************************************/
          if (usParm > 7) {
            return MWM_ATCMD_ERROR;
          } else {
            psi->Class2Capabilities.usST = usParm;
          } /* endif */
        break;
      }

    }

    /***********************************************************************/
    /* Increment to prepare for the next parameter.                        */
    /***********************************************************************/
    usParmNumber++;
    achParm = mwmParseGetNextArgument( achString, &usParmNumber );

  } /* endwhile */

//  psi->usNextATIndex += strlen(achString);
  mwmParseMoveATIndex( psi, achString );

  /*************************************************************************/
  /* The last parameter is not followed by a comma, so we need to move     */
  /* The AT Index pointer back one space...                                */
  /*************************************************************************/
//  psi->usNextATIndex--;

  /**************************************************************
  ** If the T30 task is already loaded, write the new values
  ** to its storage.
  ***************************************************************/
  psi->TempClass2Capabilities = psi->Class2Capabilities;
  usParserStatus = mwmClss2WriteTaskData( psi, psi->dsp.dspaddrCAPBUFF,
                                          &psi->Class2Capabilities, 8,
                                          szThisFile, __LINE__ );
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FDCCCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


/*****************************************************************************/
/* 06/14/95                                                                  */
/* Implement +FDCC? Command.                                                 */
/*****************************************************************************/
USHORT  mwmClss2FDCCQuestionCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT ausValues[8];
  USHORT usParmNumber;
  char   achTemp[4];
  char   achString[20] = "0,0,0,0,0,0,0,0";

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FDCCQuestionCommand entry\n");
  memset(achString,0,sizeof(achString));

  memcpy( ausValues, &psi->Class2Capabilities, 8 * sizeof(USHORT));
  for (usParmNumber = 0; usParmNumber < 8; usParmNumber++) {

    /*****************************************************************
    ** We now need to go translate the values back to the spec values
    ******************************************************************/
    switch (usParmNumber) {
      case 0:
        if (ausValues[usParmNumber] == 0) {
          strcpy( achTemp, "0" );
        } else if (ausValues[usParmNumber] == 2) {
          strcpy( achTemp, "1" );
        } /* endif */
      break;

      case 1:
        if (ausValues[usParmNumber] == 0) {
          strcpy( achTemp, "0" );
        } else if (ausValues[usParmNumber] == 1) {
          strcpy( achTemp, "1" );
        } else if (ausValues[usParmNumber] == 2) {
          strcpy( achTemp, "2" );
        } else if (ausValues[usParmNumber] == 3) {
          strcpy( achTemp, "3" );
        } else if (ausValues[usParmNumber] == 6) {
          strcpy( achTemp, "4" );
        } else if (ausValues[usParmNumber] == 7) {
          strcpy( achTemp, "5" );
        } else {
          strcpy( achTemp, "?" );
        } /* endif */
      break;

      default:
        //itoa( ausValues[usParmNumber], achTemp, 10 );
        sprintf(achTemp, "%hu", ausValues[usParmNumber]);

    } /* endswitch */

    strcat(achString, achTemp);
    if (usParmNumber != 7) {
      strcat(achString, ",");
    } /* endif */
  } /* endfor */

  usParserStatus = mwmParseEchoString(psi,achString);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FDCCQuestionCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/*****************************************************************************/
/* 10/11/94                                                                  */
/* This is used for the FDCS? query.                                         */
/*****************************************************************************/
USHORT  mwmClss2FDCSCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT ausDISFrame[2];
  ULONG  ulRC = 0;
  char   achString[20] = "0,0,0,0,0,0,0,0";

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FDCSCommand entry\n");
  if ( (psi->usNextPPIndex + strlen(achString)) < PP_BUFFER_THRESHOLD)
  {
    /*************************************************************************/
    /* if Faxman is loaded, query the dcs settings.  If not, use the settings*/
    /* listed above.                                                         */
    /*************************************************************************/

    /*************************************************************************/
    /* MTS 4285 12/01/94                                                     */
    /* We can tell that FAXMAN is loaded by checking the address specified   */
    /* for DCS.  If this value is non-zero, we know that a real DCS value    */
    /* exists...                                                             */
    /*************************************************************************/
    if (psi->dsp.dspaddrDCS)
    {
      /***********************************************************************/
      /* Read DIS(DCS) Frame from FAXMAN                                     */
      /***********************************************************************/
      ulRC = dspMemTransfer(psi->dsp.hDSP, psi->dsp.dspaddrDCS,
                            ausDISFrame, 2,
                            DSP_MEMXFER_DATA_READ);
      if (ulRC!=DSP_NOERROR)
      {
        mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                          MWM_DSP_ERROR,
                          ulRC);
        return MWM_ATCMD_ERROR;
      }

      /***********************************************************************/
      /* Call the bit manipulation routine...                                */
      /***********************************************************************/
      memset(achString,0,sizeof(achString));
      ulRC = mwmClss2ParseDCSFrame(ausDISFrame,achString, 1);
      if (ulRC)
      {
        return (USHORT)(ulRC);
      }
    }
    /*************************************************************************/
    /* At this point, achString is either set at the default (if no FAXMAN)  */
    /* or set at the real DCS settings.  Either way, we just need to echo    */
    /* them using the I command interface...                                 */
    /*************************************************************************/
    usParserStatus = mwmParseEchoString(psi,achString);
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FDCSCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}




/*****************************************************************************/
/* 06/13/95                                                                  */
/* Implement +FDIS? Command.                                                 */
/*****************************************************************************/
USHORT  mwmClss2FDISQuestionCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT ausValues[8];
  USHORT usParmNumber;
  char   achTemp[4];
  char   achString[20] = "0,0,0,0,0,0,0,0";

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FDISQuestionCommand entry\n");
  memset(achString,0,sizeof(achString));

  memcpy( ausValues, &psi->TempClass2Capabilities, 8 * sizeof(USHORT));
  for (usParmNumber = 0; usParmNumber < 8; usParmNumber++) {

    /*****************************************************************
    ** We now need to go translate the values back to the spec values
    ******************************************************************/
    switch (usParmNumber) {
      case 0:
        if (ausValues[usParmNumber] == 0) {
          strcpy( achTemp, "0" );
        } else if (ausValues[usParmNumber] == 2) {
          strcpy( achTemp, "1" );
        } /* endif */
      break;

      case 1:
        if (ausValues[usParmNumber] == 0) {
          strcpy( achTemp, "0" );
        } else if (ausValues[usParmNumber] == 1) {
          strcpy( achTemp, "1" );
        } else if (ausValues[usParmNumber] == 2) {
          strcpy( achTemp, "2" );
        } else if (ausValues[usParmNumber] == 3) {
          strcpy( achTemp, "3" );
        } else if (ausValues[usParmNumber] == 6) {
          strcpy( achTemp, "4" );
        } else if (ausValues[usParmNumber] == 7) {
          strcpy( achTemp, "5" );
        } else {
          strcpy( achTemp, "?" );
        } /* endif */
      break;

      default:
        //itoa( ausValues[usParmNumber], achTemp, 10 );
        sprintf(achTemp, "%hu", ausValues[usParmNumber]);
    } /* endswitch */

    strcat(achString, achTemp);
    if (usParmNumber != 7) {
      strcat(achString, ",");
    } /* endif */
  } /* endfor */

  usParserStatus = mwmParseEchoString(psi,achString);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FDISQuestionCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}



USHORT  mwmClss2FDISCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParmNumber = 0;
  USHORT usParm;


//char   achDebugString[30] = "\0";
  char   achCapabilities[] = "(0,1),(0-5),(0),(0-2),(0),(0),(0),(0-7)";
  char   achString[AT_CMD_BUFFER_SIZE];
  char   *achParm;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FDISCommand entry\n");
  /***************************************************************************/
  /* 10/11/94                                                                */
  /* Before we try to handle the list of parameters, look to see if the      */
  /* first parm is a '?'.  If so, this command is querying the capabilities  */
  /* rather than setting them...                                             */
  /***************************************************************************/
  if (psi->achCommandBuffer[psi->usNextATIndex] == '?')
  {
    psi->usNextATIndex++;
    usParserStatus = mwmParseEchoString(psi,achCapabilities);
    return usParserStatus;
  }

  /***************************************************************************/
  /* Do the parsing work before we ever write anything to the PP command     */
  /* buffer.                                                                 */
  /***************************************************************************/

  /****************************************************************************/
  /* At this point, the pointer is just past the =                           */
  /* We should be at the beginning of the parameter list.                    */
  /* Copy the rest of the AT command buffer string to a temporary buffer     */
  /***************************************************************************/
  strcpy(achString,&psi->achCommandBuffer[psi->usNextATIndex]);

  /***************************************************************************/
  /* Split this string apart into parameters with strtok.                    */
  /***************************************************************************/
  achParm = mwmParseGetNextArgument( achString, &usParmNumber );
  while (achParm != NULL)
  {

//    sscanf(achParm, "%hu", &usParm);
    usParm = atoi(achParm);
    DPF("Parameter %u = %u",usParmNumber,usParm);

    if (strlen(achParm))
    {
      /*********************************************************************/
      /* If there is a value at all, it is always 1 character long.        */
      /* We will do some funky ascii                                       */
      /* subtraction to get the value.                                     */
      /*********************************************************************/
//      usParm = ((char)*achParm - (char)'0');

      /*********************************************************************/
      /* Check to see if this is a valid parameter.                        */
      /* These Parameters are listed in Table 8.4 of the                   */
      /* "Asynchronous Facsimile DCE Control Standard" Dated 8/20/90       */
      /* We don't allow all of the values listed in that table.            */
      /* switch statement identifies which parameters we accept as valid   */
      /*********************************************************************/
      switch (usParmNumber)
      {
        case 0:
          /*****************************************************************/
          /* Vertical Resolution.                                          */
          /*****************************************************************/
          switch (usParm) {
            case 0:
              psi->TempClass2Capabilities.usVR = 0;
            break;
            case 1:
              psi->TempClass2Capabilities.usVR = 2;
            break;
            default:
              return MWM_ATCMD_ERROR;
          } /* endswitch */
        break;

        case 1:
          /*****************************************************************/
          /* Bit Rate                                                      */
          /*****************************************************************/
          switch (usParm) {
            case 0:
            case 1:
            case 2:
            case 3:
              psi->TempClass2Capabilities.usBR = usParm;
            break;
            case 4:
              psi->TempClass2Capabilities.usBR = 6;
            break;
            case 5:
              psi->TempClass2Capabilities.usBR = 7;
            break;
            default:
              return MWM_ATCMD_ERROR;
          } /* endswitch */
        break;

        case 2:
          /*****************************************************************/
          /* Page Width                                                    */
          /*****************************************************************/
          switch (usParm) {
            case 0:
            case 1:
            case 2:
              psi->TempClass2Capabilities.usWD = usParm;
            break;
            default:
              return MWM_ATCMD_ERROR;
          } /* endswitch */
        break;

        case 3:
          /*****************************************************************/
          /* Page Length                                                   */
          /*****************************************************************/
          switch (usParm) {
            case 0:
            case 1:
            case 2:
              psi->TempClass2Capabilities.usLN = usParm;
            break;
            default:
              return MWM_ATCMD_ERROR;
          } /* endswitch */
        break;

        case 4:
          /*****************************************************************/
          /* Data Compression Format                                       */
          /*****************************************************************/
          if (usParm > 0) {
            return MWM_ATCMD_ERROR;
          } else {
            psi->TempClass2Capabilities.usDF = usParm;
          } /* endif */
        break;

        case 5:
          /*****************************************************************/
          /* Error Correction                                              */
          /*****************************************************************/
          if (usParm > 0) {
            return MWM_ATCMD_ERROR;
          } else {
            psi->TempClass2Capabilities.usEC = usParm;
          } /* endif */
        break;

        case 6:
          /*****************************************************************/
          /* BFT                                                           */
          /*****************************************************************/
          if (usParm > 0) {
            return MWM_ATCMD_ERROR;
          } else {
            psi->TempClass2Capabilities.usBF = usParm;
          } /* endif */
        break;

        case 7:
          /*****************************************************************/
          /* Scan Time/Line                                                */
          /* Currently, we allow this parameter to be up to 7, but we      */
          /* don't do anything with it.                                    */
          /*****************************************************************/
          if (usParm > 7) {
            return MWM_ATCMD_ERROR;
          } else {
            psi->TempClass2Capabilities.usST = usParm;
          } /* endif */
        break;
      }

    }

    /***********************************************************************/
    /* Increment to prepare for the next parameter.                        */
    /***********************************************************************/
    usParmNumber++;
    achParm = mwmParseGetNextArgument( achString, &usParmNumber );

  } /* endwhile */

//  psi->usNextATIndex += strlen(achString);
  mwmParseMoveATIndex( psi, achString );

  /*************************************************************************/
  /* The last parameter is not followed by a comma, so we need to move     */
  /* The AT Index pointer back one space...                                */
  /*************************************************************************/
//  psi->usNextATIndex--;

  /**************************************************************
  ** If the T30 task is already loaded, write the new values
  ** to its storage.
  ***************************************************************/
  usParserStatus = mwmClss2WriteTaskData( psi, psi->dsp.dspaddrCAPBUFF,
                                          &psi->TempClass2Capabilities, 8,
                                          szThisFile, __LINE__ );
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FDISCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;

}





USHORT  mwmClss2FDRCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FDRCommand entry\n");
  if ( (psi->usNextPPIndex + PP_FDR_CMD_SPACE) < PP_BUFFER_THRESHOLD)
  {
//  psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0109 | psi->usParserMode;
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x10;
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x06;
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FDRCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}








USHORT  mwmClss2FDTCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  char   achString[AT_CMD_BUFFER_SIZE];
  char   *achParm;
  USHORT usParmNumber;
  USHORT usParm;
  BOOL   bParameterChanged = FALSE;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FDTCommand entry\n");
  if ( (psi->usNextPPIndex + PP_FDT_CMD_SPACE) < PP_BUFFER_THRESHOLD)
  {

    /****************************************************************
    ** Check for optional parameters
    *****************************************************************/
    if (psi->achCommandBuffer[psi->usNextATIndex] == '=') {
      psi->usNextATIndex++;

      strcpy(achString,&psi->achCommandBuffer[psi->usNextATIndex]);
      achParm = mwmParseGetNextArgument( achString, &usParmNumber );
      while (achParm != NULL)
      {

//        sscanf(achParm, "%hu", &usParm);
        usParm = atoi(achParm);
        DPF("Parameter %u = %u",usParmNumber,usParm);

        if (strlen(achParm))
        {
          bParameterChanged = TRUE;
          /*********************************************************************/
          /* If there is a value at all, it is always 1 character long.        */
          /* We will do some funky ascii                                       */
          /* subtraction to get the value.                                     */
          /*********************************************************************/
//          usParm = ((char)*achParm - (char)'0');

          /*********************************************************************/
          /* Check to see if this is a valid parameter.                        */
          /* These Parameters are listed in Table 8.4 of the                   */
          /* "Asynchronous Facsimile DCE Control Standard" Dated 8/20/90       */
          /* We don't allow all of the values listed in that table.            */
          /* switch statement identifies which parameters we accept as valid   */
          /*********************************************************************/
          switch (usParmNumber)
          {
            case 0:
              /*****************************************************************/
              /* Data Compression Format                                       */
              /*****************************************************************/
              if (usParm > 0) {
                return MWM_ATCMD_ERROR;
              } else {
                psi->TempClass2Capabilities.usDF = usParm;
              } /* endif */
            break;

            case 1:
              /*****************************************************************/
              /* Vertical Resolution.                                          */
              /*****************************************************************/
              switch (usParm) {
                case 0:
                  psi->Class2Capabilities.usVR = 0;
                break;
                case 1:
                  psi->Class2Capabilities.usVR = 2;
                break;
                default:
                  return MWM_ATCMD_ERROR;
              } /* endswitch */
            break;

            case 2:
              /*****************************************************************/
              /* Page Width                                                    */
              /*****************************************************************/
              switch (usParm) {
                case 0:
                case 1:
                case 2:
                  psi->Class2Capabilities.usWD = usParm;
                break;
                default:
                  return MWM_ATCMD_ERROR;
              } /* endswitch */
            break;

            case 3:
              /*****************************************************************/
              /* Page Length                                                   */
              /*****************************************************************/
              switch (usParm) {
                case 0:
                case 1:
                case 2:
                  psi->Class2Capabilities.usLN = usParm;
                break;
                default:
                  return MWM_ATCMD_ERROR;
              } /* endswitch */
            break;
          }

        }

        /***********************************************************************/
        /* Increment to prepare for the next parameter.                        */
        /***********************************************************************/
        usParmNumber++;
        achParm = mwmParseGetNextArgument( achString, &usParmNumber );

      } /* endwhile */

//      psi->usNextATIndex += strlen(achString);
      mwmParseMoveATIndex( psi, achString );

      if (bParameterChanged) {
        usParserStatus = mwmClss2WriteTaskData( psi, psi->dsp.dspaddrCAPBUFF,
                                                &psi->TempClass2Capabilities, 8,
                                                szThisFile, __LINE__ );
      } /* endif */
    } /* endif */

    if (!usParserStatus) {
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x10;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x08;
    } /* endif */
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FDTCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}




USHORT  mwmClss2FDVPSCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  char   *achVersionString = "Brad Marshall, Ray Chandler, Allen Mitchell, Tim Marks, David Rivera";
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FDVPSCommand entry\n");

  /*****************************************************************************/
  /* This situation is fine as long as the Developers ID is less than 98       */
  /* Characters (or whatever the BUFFER_THRESHOLD is set to).                  */
  /*****************************************************************************/

  usParserStatus = mwmParseEchoString(psi,achVersionString);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FDVPSCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}







USHORT  mwmClss2FETCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FETCCommand entry\n");
  if ( (psi->usNextPPIndex + PP_FET_CMD_SPACE) < PP_BUFFER_THRESHOLD)
  {

     usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                    &psi->usNextATIndex);

     switch(usParm)
     {
       case 0:
       case 1:
       case 2:
         psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x10;
         psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0A;
         psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
         break;
       default:
         usParserStatus = MWM_ATCMD_ERROR;
         break;
     }


  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FETCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}



USHORT  mwmClss2FKCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FKCommand entry\n");
  if ( (psi->usNextPPIndex + PP_FK_CMD_SPACE) < PP_BUFFER_THRESHOLD)
  {
//    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0112 | psi->usParserMode;
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x10;
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0C;
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FKCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}





USHORT  mwmClss2FLIDCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usNumChars = 0;
  USHORT usActualChars = 0;
  char   achTempBuffer[30];
  char   achFLIDString[21];

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FLIDCommand entry\n");
  /***************************************************************************/
  /* Look for first double quote...should be next character...               */
  /***************************************************************************/
  if (psi->achCommandBuffer[psi->usNextATIndex++] != '\"')
    return MWM_ATCMD_ERROR;


  /***************************************************************************/
  /* OK...we are past the first quote...place the rest in the Temporary      */
  /* Buffer.                                                                 */
  /***************************************************************************/
  while ( (psi->achCommandBuffer[psi->usNextATIndex] != '\"')  &&
          (usNumChars < 21 ) )
  {
    achTempBuffer[usNumChars] = psi->achCommandBuffer[psi->usNextATIndex++];
    usNumChars++;
  }

  /***************************************************************************/
  /* If we didn't find a " within the first 20 characters, then it is an     */
  /* Error.                                                                  */
  /***************************************************************************/
  if (usNumChars > 20)
    return MWM_ATCMD_ERROR;

  /***************************************************************************/
  /* 9/17/94 Pad with spaces out to 20 characters...                         */
  /***************************************************************************/
  usActualChars = usNumChars;
  while (usNumChars < 20)
  {
    achTempBuffer[usNumChars] = (USHORT)' ';
    usNumChars++;
  }

  /***************************************************************************/
  /* Advance the AT Command pointer past the quote.                          */
  /***************************************************************************/
  psi->usNextATIndex++;


  /***************************************************************************/
  /* We have made it this far, so the command syntax must be correct.        */
  /* Start placing the PP Commands into the buffer.                          */
  /***************************************************************************/

  /***************************************************************************/
  /* Now copy in the bytes ... swapping just like in the ParseEchoString     */
  /* function.                                                               */
  /* In fact, the following segment was lifted directly from                 */
  /* mwmParseEchoString                                                      */
  /***************************************************************************/
  /***************************************************************************/
  /* Copy in the character string...packing the characters into the          */
  /* word (USHORT) array.                                                    */
  /***************************************************************************/
//  strcpy((char *)&psi->ausPPcmdBuffer[psi->usNextPPIndex],achTempBuffer);

  /************************************************************
  ** Right-justify the resulting string. Copy the actual
  ** characters found to the end of the space-padded string
  *************************************************************/
  memset(achFLIDString, ' ', sizeof(achFLIDString));
  strncpy( (char *)(achFLIDString+(20-usActualChars)), achTempBuffer, usActualChars);

  swab(achFLIDString, achFLIDString, ((usNumChars+1)/2)*2);
  strcpy(psi->achFLIDString, achFLIDString);
  usParserStatus = mwmClss2WriteTaskData( psi, psi->dsp.dspaddrMYID,
                                          (PVOID)psi->achFLIDString, 10,
                                          szThisFile, __LINE__);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FLIDCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmClss2FCIGCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usNumChars = 0;
  USHORT usActualChars = 0;
  char   achTempBuffer[30];
  char   achFCIGString[21];

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FCIGCommand entry\n");
  /***************************************************************************/
  /* Look for first double quote...should be next character...               */
  /***************************************************************************/
  if (psi->achCommandBuffer[psi->usNextATIndex++] != '\"')
    return MWM_ATCMD_ERROR;


  /***************************************************************************/
  /* OK...we are past the first quote...place the rest in the Temporary      */
  /* Buffer.                                                                 */
  /***************************************************************************/
  while ( (psi->achCommandBuffer[psi->usNextATIndex] != '\"')  &&
          (usNumChars < 21 ) )
  {
    achTempBuffer[usNumChars] = psi->achCommandBuffer[psi->usNextATIndex++];
    usNumChars++;
  }

  /***************************************************************************/
  /* If we didn't find a " within the first 20 characters, then it is an     */
  /* Error.                                                                  */
  /***************************************************************************/
  if (usNumChars > 20)
    return MWM_ATCMD_ERROR;

  /***************************************************************************/
  /* 9/17/94 Pad with spaces out to 20 characters...                         */
  /***************************************************************************/
  usActualChars = usNumChars;
  while (usNumChars < 20)
  {
    achTempBuffer[usNumChars] = (USHORT)' ';
    usNumChars++;
  }

  /***************************************************************************/
  /* Advance the AT Command pointer past the quote.                          */
  /***************************************************************************/
  psi->usNextATIndex++;


  /***************************************************************************/
  /* We have made it this far, so the command syntax must be correct.        */
  /* Start placing the PP Commands into the buffer.                          */
  /***************************************************************************/

  /***************************************************************************/
  /* Now copy in the bytes ... swapping just like in the ParseEchoString     */
  /* function.                                                               */
  /* In fact, the following segment was lifted directly from                 */
  /* mwmParseEchoString                                                      */
  /***************************************************************************/
  /***************************************************************************/
  /* Copy in the character string...packing the characters into the          */
  /* word (USHORT) array.                                                    */
  /***************************************************************************/
//  strcpy((char *)&psi->ausPPcmdBuffer[psi->usNextPPIndex],achTempBuffer);

  /************************************************************
  ** Right-justify the resulting string. Copy the actual
  ** characters found to the end of the space-padded string
  *************************************************************/
  memset(achFCIGString, ' ', sizeof(achFCIGString));
  strncpy( (char *)(achFCIGString+(20-usActualChars)), achTempBuffer, usActualChars);

  swab(achFCIGString, achFCIGString, ((usNumChars+1)/2)*2);
  strcpy(psi->achFCIGString, achFCIGString);
  usParserStatus = mwmClss2WriteTaskData( psi, psi->dsp.dspaddrMYCIG,
                                          (PVOID)psi->achFCIGString, 10,
                                          szThisFile, __LINE__);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FCIGCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}






USHORT  mwmClss2FMFRCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  char   *achVersionString = "IBM Mwave";

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FMFRCommand entry\n");
  /*****************************************************************************/
  /* This situation is fine as long as the Manufacturers ID is less than 98    */
  /* Characters (or whatever the BUFFER_THRESHOLD is set to).                  */
  /*                                                                           */
  /* If the ID is longer than 98 characters, we will need to implement a       */
  /* state machine similar to what is used by the i2,i3, and &v commands.      */
  /* This is possible, and should probably be done at some point.              */
  /*****************************************************************************/

  usParserStatus = mwmParseEchoString(psi,achVersionString);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FMFRCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


USHORT  mwmClss2FREVCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FREVCommand entry\n");
  /*****************************************************************************/
  /* This situation is fine as long as the Rev ID is less than 98              */
  /* Characters (or whatever the BUFFER_THRESHOLD is set to).                  */
  /*                                                                           */
  /* If the ID is longer than 98 characters, we will need to implement a       */
  /* state machine similar to what is used by the i2,i3, and &v commands.      */
  /* This is possible, and should probably be done at some point.              */
  /*****************************************************************************/
  usParserStatus = mwmParseEchoString(psi,psi->achModemVersion);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FREVCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


USHORT  mwmClss2FAXERRCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  char   achString[AT_CMD_BUFFER_SIZE];

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2FAXERRCommand entry\n");
  /* paulsch
   * itoa(psi->usFAXERR, achString, 10);
   */
  sprintf(achString, "%hu", psi->usFAXERR);
  usParserStatus = mwmParseEchoString( psi, achString );
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss2::mwmClss2FAXERRCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;

}

ULONG MWM_ENTRY mwmClss2ParseDCSFrame(USHORT *ausDCSFrame,char *achString, USHORT usDCSFlag)
{
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2ParseDCSFrame entry\n");
  /***************************************************************************/
  /* Get the Vertical Resolution from the DIS Frame, and put it in the string*/
  /***************************************************************************/
  if (ausDCSFrame[0] & 0x0002)
    strcpy(achString,"1,");
  else
    strcpy(achString,"0,");

  /***************************************************************************/
  /* Get the Bit Rate from the DIS Frame, and put it in the string           */
  /* Mask to get the 3 proper bits, then shift them to the right to get the  */
  /* right speed                                                             */
  /* 01/29/97 - DR - Use usDCSFlag to determine if the parsing is being done */
  /* for the FDCS or the FDIS/FDTC commands. The speeds reported by FDIS/FDTC*/
  /* differ from the FDCE response.                                          */
  /***************************************************************************/
  if (usDCSFlag) {
    switch ( ( ausDCSFrame[0] & 0x003c) >> 2)
    {

      case 0:
        /***********************************************************************/
        /* 2400                                                                */
        /***********************************************************************/
        strcat(achString,"0,");
        break;
      case 4:
        /***********************************************************************/
        /* 4800                                                                */
        /***********************************************************************/
        strcat(achString,"1,");
        break;
      case 0xC:
      case 0xD:
        /***********************************************************************/
        /* 7200                                                                */
        /***********************************************************************/
        strcat(achString,"2,");
        break;
      case 8:
      case 9:
        /***********************************************************************/
        /* 9600                                                                */
        /***********************************************************************/
        strcat(achString,"3,");
        break;
      case 5:
      case 6:
        /***********************************************************************/
        /* 12000                                                               */
        /***********************************************************************/
        strcat(achString,"4,");
        break;
      case 1:
      case 2:
        /***********************************************************************/
        /* 14400                                                               */
        /***********************************************************************/
        strcat(achString,"5,");
        break;
      default:
        /***********************************************************************/
        /* 14400                                                               */
        /***********************************************************************/
        strcat(achString,"5,");
        break;

    }
  } else {
    switch ( ( ausDCSFrame[0] & 0x003c) >> 2)
    {

      case 0:
        /***********************************************************************/
        /* 2400                                                                */
        /***********************************************************************/
        strcat(achString,"0,");
        break;
      case 4:
        /***********************************************************************/
        /* 4800                                                                */
        /***********************************************************************/
        strcat(achString,"1,");
        break;
      case 8:
      case 0xC:
      case 0xE:
        /***********************************************************************/
        /* 9600                                                                */
        /***********************************************************************/
        strcat(achString,"3,");
        break;
      case 0xD:
        /***********************************************************************/
        /* 14400                                                               */
        /***********************************************************************/
        strcat(achString,"5,");
        break;
      default:
        /***********************************************************************/
        /* 14400                                                               */
        /***********************************************************************/
        strcat(achString,"5,");
        break;

    }

  } /* endif */


  /***************************************************************************/
  /* Get the Page Width from the DIS Frame, and put it in the string         */
  /***************************************************************************/
  switch ( ( ausDCSFrame[1] & 0xc000) >> 14)
  {
    case 0:
      strcat(achString,"0,");
      break;
    case 1:
      strcat(achString,"2,");
      break;
    case 2:
      strcat(achString,"1,");
      break;
    default:
      strcat(achString,"0,");
      break;
  }

  /***************************************************************************/
  /* Get the Page Length from the DIS Frame, and put it in the string        */
  /***************************************************************************/
  switch ( ( ausDCSFrame[1] & 0x3000) >> 12)
  {
    case 0:
      strcat(achString,"0,");
      break;
    case 1:
      strcat(achString,"2,");
      break;
    case 2:
      strcat(achString,"1,");
      break;
    default:
      strcat(achString,"0,");
      break;
  }

  /***************************************************************************/
  /* DF                                                                      */
  /* Data Compression Format.                                                */
  /* I couldn't figure out how to get this from the DIS Frame.               */
  /* For now, it doesn't matter since we don't support anything except       */
  /* 1-D Modified Hufham                                                     */
  /* Copy a 0 into the Parm string to identify 1-D Modified Hufham           */
  /***************************************************************************/
  strcat(achString,"0,");

  /***************************************************************************/
  /* Get the Error Correction Mode from the DIS Frame                        */
  /***************************************************************************/
  switch ( ( ausDCSFrame[1] & 0x0030) >> 4)
  {
    case 0:
    case 1:
      strcat(achString,"0,");
      break;
    case 2:
      strcat(achString,"2,");
      break;
    case 3:
      strcat(achString,"1,");
      break;
    default:
      strcat(achString,"0,");
      break;
  }

  /***************************************************************************/
  /* BFT                                                                     */
  /* Binary File Transfer                                                    */
  /* I couldn't figure out how to get this from the DIS Frame.               */
  /* For now, it doesn't matter since we don't support BFT                   */
  /* Copy a 0 into the Parm string to identify "Disable BFT"                 */
  /***************************************************************************/
  strcat(achString,"0,");


  /***************************************************************************/
  /* Get the Scan Time/LIne   from the DIS Frame                             */
  /***************************************************************************/
  switch ( ( ausDCSFrame[1] & 0x0e00) >> 9)
  {
    case 0:
      strcat(achString,"5");
      break;
    case 1:
      strcat(achString,"7");
      break;
    case 2:
      strcat(achString,"3");
      break;
    case 3:
      strcat(achString,"2");
      break;
    case 4:
      strcat(achString,"1");
      break;
    case 5:
      strcat(achString,"6");
      break;
    case 6:
      strcat(achString,"4");
      break;
    case 7:
      strcat(achString,"0");
      break;
    default:
      strcat(achString,"0");
      break;
  }
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2ParseDCSFrame exit ulRC 0\n");
  return 0;
}



USHORT mwmClss2WriteTaskData( STATEINFO *psi, ULONG ulDSPAddress,
                              PVOID pData, USHORT usNumWords,
                              char *szFilename, USHORT usLine)
{

  ULONG ulRC = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2WriteTaskData entry\n");
  if (ulDSPAddress) {
    ulRC = dspMemTransfer( psi->dsp.hDSP, ulDSPAddress, pData, usNumWords,
                           DSP_MEMXFER_DATA_WRITE);
    if (ulRC != DSP_NOERROR) {
      mwmIPCHandleError( szFilename, usLine, &psi->mwmError, MWM_DSP_ERROR,
                         ulRC);
      return MWM_ATCMD_ERROR;
    } /* endif */
  } /* endif */
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss2::mwmClss2WriteTaskData exit ulRC 0\n");
  return 0;

}
