// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BndLib_Add2dCurve_HeaderFile
#define _BndLib_Add2dCurve_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Adaptor2d_Curve2d;
class Bnd_Box2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Computes the bounding box for a curve in 2d . <br>
//! Functions to add a 2D curve to a bounding box. <br>
//! The 2D curve is defined from a Geom2d curve. <br>
class BndLib_Add2dCurve  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Adds to the bounding box B the curve C <br>
//!  B is then enlarged by the tolerance value Tol. <br>
//! Note: depending on the type of curve, one of the following <br>
//! representations of the curve C is used to include it in the bounding box B: <br>
//! -   an exact representation if C is built from a line, a circle   or a conic curve, <br>
//! -   the poles of the curve if C is built from a Bezier curve or   a BSpline curve, <br>
//! -   if not, the points of an approximation of the curve C. <br>
//! Warning <br>
//! C is an adapted curve, that is, an object which is an interface between: <br>
//! -   the services provided by a 2D curve from the package Geom2d <br>
//! -   and those required of the curve by the computation algorithm. <br>
//!  The adapted curve is created in the following way: <br>
//!    Handle(Geom2d_Curve) mycurve = ... <br>
//! ; <br>
//!    Geom2dAdaptor_Curve C(mycurve); <br>
//! The bounding box B is then enlarged by adding it: <br>
//!    Bnd_Box2d B; <br>
//! // ... <br>
//!    Standard_Real Tol = ... ; <br>
//!    Add2dCurve::Add ( C, Tol, B ); <br>
//! Exceptions <br>
//! Standard_Failure if the curve is built from: <br>
//! -   a Geom_Line, or <br>
//! -   a Geom_Parabola, or <br>
//! -   a Geom_Hyperbola, <br>
//! and P1 and P2 are either two negative infinite real <br>
//! numbers, or two positive infinite real numbers. <br>
Standard_EXPORT static  void Add(const Adaptor2d_Curve2d& C,const Standard_Real Tol,Bnd_Box2d& B) ;

//! Adds to the bounding box Bthe arc of the curve C limited by the two parameter <br>
//!  values P1 and P2. <br>
//!  B is then enlarged by the tolerance value Tol. <br>
//! Note: depending on the type of curve, one of the following <br>
//! representations of the curve C is used to include it in the bounding box B: <br>
//! -   an exact representation if C is built from a line, a circle   or a conic curve, <br>
//! -   the poles of the curve if C is built from a Bezier curve or   a BSpline curve, <br>
//! -   if not, the points of an approximation of the curve C. <br>
//! Warning <br>
//! C is an adapted curve, that is, an object which is an interface between: <br>
//! -   the services provided by a 2D curve from the package Geom2d <br>
//! -   and those required of the curve by the computation algorithm. <br>
//!  The adapted curve is created in the following way: <br>
//!    Handle(Geom2d_Curve) mycurve = ... <br>
//! ; <br>
//!    Geom2dAdaptor_Curve C(mycurve); <br>
//! The bounding box B is then enlarged by adding it: <br>
//!    Bnd_Box2d B; <br>
//! // ... <br>
//!    Standard_Real Tol = ... ; <br>
//!    Add2dCurve::Add ( C, Tol, B ); <br>
//! Exceptions <br>
//! Standard_Failure if the curve is built from: <br>
//! -   a Geom_Line, or <br>
//! -   a Geom_Parabola, or <br>
//! -   a Geom_Hyperbola, <br>
//! and P1 and P2 are either two negative infinite real <br>
//! numbers, or two positive infinite real numbers. <br>
Standard_EXPORT static  void Add(const Adaptor2d_Curve2d& C,const Standard_Real U1,const Standard_Real U2,const Standard_Real Tol,Bnd_Box2d& B) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
