// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Expr_GeneralExpression_HeaderFile
#define _Expr_GeneralExpression_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Expr_GeneralExpression_HeaderFile
#include <Handle_Expr_GeneralExpression.hxx>
#endif

#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Expr_NamedUnknown_HeaderFile
#include <Handle_Expr_NamedUnknown.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_OutOfRange;
class Standard_NumericError;
class Expr_NotEvaluable;
class Expr_InvalidOperand;
class Expr_NamedUnknown;
class Expr_Array1OfNamedUnknown;
class TColStd_Array1OfReal;
class TCollection_AsciiString;


//! Defines the general purposes of any expression. <br>
class Expr_GeneralExpression : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Returns the number of sub-expressions contained <br>
//!          in <me> ( >= 0) <br>
Standard_EXPORT virtual  Standard_Integer NbSubExpressions() const = 0;

//! Returns the <I>-th sub-expression of <me> <br>
//!          raises OutOfRange if <I> > NbSubExpressions(me) <br>
Standard_EXPORT virtual const Handle_Expr_GeneralExpression& SubExpression(const Standard_Integer I) const = 0;

//! Returns a GeneralExpression after replacement of <br>
//!          NamedUnknowns by an associated expression and after <br>
//!          values computation. <br>
Standard_EXPORT virtual  Handle_Expr_GeneralExpression Simplified() const = 0;

//! Returns a GeneralExpression after a simplification <br>
//!          of the arguments of <me>. <br>
Standard_EXPORT virtual  Handle_Expr_GeneralExpression ShallowSimplified() const = 0;

//! Returns a copy of <me> having the same unknowns and <br>
//!          functions. <br>
Standard_EXPORT virtual  Handle_Expr_GeneralExpression Copy() const = 0;

//! Tests if <me> contains NamedUnknowns. <br>
Standard_EXPORT virtual  Standard_Boolean ContainsUnknowns() const = 0;

//! Tests if <exp> is contained in <me>. <br>
Standard_EXPORT virtual  Standard_Boolean Contains(const Handle(Expr_GeneralExpression)& exp) const = 0;

//! Tests if <me> is linear on every NamedUnknown it <br>
//!          contains. <br>
Standard_EXPORT virtual  Standard_Boolean IsLinear() const = 0;

//! Tests if <me> can be shared by one or more expressions <br>
//!          or must be copied. This method returns False as a <br>
//!          default value. To be redefined ( especially for <br>
//!          NamedUnknown). <br>
Standard_EXPORT virtual  Standard_Boolean IsShareable() const;

//! Tests if <me> and <Other> define the same expression. <br>
//!  Warning: This method does not include any simplification before <br>
//!          testing. It could also be very slow; to be used <br>
//!          carefully. <br>
Standard_EXPORT virtual  Standard_Boolean IsIdentical(const Handle(Expr_GeneralExpression)& Other) const = 0;

//! Returns the derivative on <X> unknown of <me> <br>
Standard_EXPORT virtual  Handle_Expr_GeneralExpression Derivative(const Handle(Expr_NamedUnknown)& X) const = 0;

//! Returns the <N>-th derivative on <X> unknown of <me>. <br>
//!          Raise OutOfRange if N <= 0 <br>
Standard_EXPORT virtual  Handle_Expr_GeneralExpression NDerivative(const Handle(Expr_NamedUnknown)& X,const Standard_Integer N) const;

//! Replaces all occurences of <var> with copies of <with> <br>
//!          in <me>. Copies of <with> are made with the Copy() method. <br>
//!          Raises InvalidOperand if <with> contains <me>. <br>
Standard_EXPORT virtual  void Replace(const Handle(Expr_NamedUnknown)& var,const Handle(Expr_GeneralExpression)& with)  = 0;

//! Returns the value of <me> (as a Real) by <br>
//!          replacement of <vars> by <vals>. <br>
//!          Raises NotEvaluable if <me> contains NamedUnknown not <br>
//!          in <vars> or NumericError if result cannot be computed. <br>
Standard_EXPORT virtual  Standard_Real Evaluate(const Expr_Array1OfNamedUnknown& vars,const TColStd_Array1OfReal& vals) const = 0;

//! Returns the value of <me> (as a Real) by <br>
//!          replacement of <vars> by <vals>. <br>
//!          Raises NotEvaluable if <me> contains NamedUnknown not <br>
//!          in <vars> or NumericError if result cannot be computed. <br>
Standard_EXPORT   Standard_Real EvaluateNumeric() const;

//! returns a string representing <me> in a readable way. <br>
Standard_EXPORT virtual  TCollection_AsciiString String() const = 0;
//Standard_EXPORT ~Expr_GeneralExpression();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
