// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GCE2d_MakeLine_HeaderFile
#define _GCE2d_MakeLine_HeaderFile

#ifndef _Handle_Geom2d_Line_HeaderFile
#include <Handle_Geom2d_Line.hxx>
#endif
#ifndef _GCE2d_Root_HeaderFile
#include <GCE2d_Root.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Geom2d_Line;
class StdFail_NotDone;
class gp_Ax2d;
class gp_Lin2d;
class gp_Pnt2d;
class gp_Dir2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class implements the following algorithms used <br>
//!           to create a Line from Geom2d. <br>
//!           * Create a Line parallel to another and passing <br>
//!             through a point. <br>
//!           * Create a Line passing through 2 points. <br>
class GCE2d_MakeLine  : public GCE2d_Root {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//!  Creates a line located in 2D space with the axis placement A. <br>
//!  The Location of A is the origin of the line. <br>
Standard_EXPORT GCE2d_MakeLine(const gp_Ax2d& A);


//!  Creates a line from a non persistent line from package gp. <br>
Standard_EXPORT GCE2d_MakeLine(const gp_Lin2d& L);


//!  P is the origin and V is the direction of the line. <br>
Standard_EXPORT GCE2d_MakeLine(const gp_Pnt2d& P,const gp_Dir2d& V);

//! Make a Line from Geom2d <TheLin> parallel to another <br>
//!           Lin <Lin> and passing through a Pnt <Point>. <br>
Standard_EXPORT GCE2d_MakeLine(const gp_Lin2d& Lin,const gp_Pnt2d& Point);

//! Make a Line from Geom2d <TheLin> parallel to another <br>
//!           Lin <Lin> at a distance <Dist>. <br>
Standard_EXPORT GCE2d_MakeLine(const gp_Lin2d& Lin,const Standard_Real Dist);

//! Make a Line from Geom2d <TheLin> passing through 2 <br>
//!           Pnt <P1>,<P2>. <br>
//!           It returns false if <p1> and <P2> are confused. <br>
//! Warning <br>
//! If points P1 and P2 coincident (that is, when IsDone <br>
//! returns false), the Status function returns gce_ConfusedPoints. <br>
Standard_EXPORT GCE2d_MakeLine(const gp_Pnt2d& P1,const gp_Pnt2d& P2);

//! Returns the constructed line. <br>
//! Exceptions StdFail_NotDone if no line is constructed. <br>
Standard_EXPORT  const Handle_Geom2d_Line& Value() const;


Standard_EXPORT  const Handle_Geom2d_Line& Operator() const;
Standard_EXPORT operator Handle_Geom2d_Line() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom2d_Line TheLine;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
