// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSelect_SelectSubordinate_HeaderFile
#define _IGESSelect_SelectSubordinate_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSelect_SelectSubordinate_HeaderFile
#include <Handle_IGESSelect_SelectSubordinate.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _IFSelect_SelectExtract_HeaderFile
#include <IFSelect_SelectExtract.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
class Standard_Transient;
class Interface_InterfaceModel;
class TCollection_AsciiString;


//! This selections uses Subordinate Status as sort criterium <br>
//!           It is an integer number which can be : <br>
//!           0 Independant <br>
//!           1 Physically Dependant <br>
//!           2 Logically Dependant <br>
//!           3 Both (recorded) <br>
//!           + to sort : <br>
//!           4 : 1 or 3  ->  at least Physically <br>
//!           5 : 2 or 3  ->  at least Logically <br>
//!           6 : 1 or 2 or 3 -> any kind of dependance <br>
//!             (corresponds to 0 reversed) <br>
class IGESSelect_SelectSubordinate : public IFSelect_SelectExtract {

public:
 // Methods PUBLIC
 // 

//! Creates a SelectSubordinate with a status to be sorted <br>
Standard_EXPORT IGESSelect_SelectSubordinate(const Standard_Integer status);

//! Returns the status used for sorting <br>
Standard_EXPORT   Standard_Integer Status() const;

//! Returns True if <ent> is an IGES Entity with Subordinate <br>
//!           Status matching the criterium <br>
Standard_EXPORT   Standard_Boolean Sort(const Standard_Integer rank,const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) const;

//! Returns the Selection criterium : "IGES Entity, Independant" <br>
//!           etc... <br>
Standard_EXPORT   TCollection_AsciiString ExtractLabel() const;
//Standard_EXPORT ~IGESSelect_SelectSubordinate();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer thestatus;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
