// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeAnalysis_Geom_HeaderFile
#define _ShapeAnalysis_Geom_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TColStd_HArray2OfReal_HeaderFile
#include <Handle_TColStd_HArray2OfReal.hxx>
#endif
class Standard_OutOfRange;
class TColgp_Array1OfPnt;
class gp_Pln;
class TColStd_HArray2OfReal;
class gp_Trsf;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Analyzing tool aimed to work on primitive geometrical objects <br>
class ShapeAnalysis_Geom  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Builds a plane out of a set of points in array <br>
//!           Returns in <dmax> the maximal distance between the produced <br>
//!           plane and given points <br>
Standard_EXPORT static  Standard_Boolean NearestPlane(const TColgp_Array1OfPnt& Pnts,gp_Pln& aPln,Standard_Real& Dmax) ;

//! Builds transfromation object out of matrix. <br>
//!          Matrix must be 3 x 4. <br>
//!          Unit is used as multiplier. <br>
Standard_EXPORT static  Standard_Boolean PositionTrsf(const Handle(TColStd_HArray2OfReal)& coefs,gp_Trsf& trsf,const Standard_Real unit,const Standard_Real prec) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
