/* CRDELT.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#include <SysBase.h>
/* Common Block Declarations */

extern struct {
    long int icore[12000];	/* was [12][1000] */
    integer ncore, lprot;
} mcrgene_;

#define mcrgene_1 mcrgene_

extern struct {
    integer nrqst[2], ndelt[2], nbyte[2], mbyte[2];
} mcrstac_;

#define mcrstac_1 mcrstac_

/* Subroutine */ __SysBase_API int mcrdelt_(iunit, isize, t, iofset, iercod)
integer *iunit, *isize;
doublereal *t;
integer *iercod;
long int *iofset;
{
    static integer ibid;
    static doublereal xbid;
    static integer noct, iver, ksys, i__, n, nrang, 
	    ibyte, ier;
    static long int iadfd,  iadff, iaddr, loc; /* Les adrresses en long*/
    extern /* Subroutine */ int madbtbk_(), macrchk_();
    static integer kop;
    extern /* Subroutine */ int mcrfree_(), macrclw_(), mcrfill_(), maermsg_()
	    , macrmsg_(), mcrcomm_(), mcrlocv_(), maostrd_();

/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*        DESTRUCTION D'UNE ALLOCATION DYNAMIQUE */

/*     MOTS CLES : */
/*     ----------- */
/*        SYSTEME, ALLOCATION, MEMOIRE, DESTRUCTION */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*        IUNIT  : NOMBRE D'OCTETS DE L'UNITE D'ALLOCATION */
/*        ISIZE  : NOMBRE D'UNITES DEMANDEES */
/*        T      : ADRESSE DE REFERENCE */
/*        IOFSET : DECALAGE */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*        IERCOD : CODE D'ERREUR */
/*               = 0 : OK */
/*               = 1 : PB DE DE-ALLOCATION D'UNE ZONE ALLOUEE EN COMMON */
/*               = 2 : LE SYSTEME REFUSE LA DEMANDE DE DE-ALLOCATION */
/*               = 3 : L'ALLOCATION A DETRUIRE N'EXISTE PAS. */

/*     COMMONS UTILISES   : */
/*     ---------------- */


/*     REFERENCES APPELEES   : */
/*     ---------------------- */


/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/*     1) UTILISATEUR */
/*        ----------- */

/*       MCRDELT FAIT UNE LIBERATION DE ZONE MEMOIRE ALLOUEE */
/*       PAR LA ROUTINE MCRRQST (OU CRINCR) */

/*       LA SIGNIFICATION DES ARGUMENTS EST LA MEME QUE MCRRQST */

/* *** ATTENTION : */
/*     ----------- */
/*     IERCOD=2 : CAS OU LE SYSTEME NE PEUT LIBERER LA MEMOIRE ALLOUEE, */
/*     LE MESSAGE SUIVANT APPARAIT SYSTEMATIQUEMENT SUR LA CONSOLE */
/*     ALPHA : */
/*     "Le systeme refuse une destruction d'allocation de memoire" */

/*     IERCOD=3 CORRESPOND AU CAS OU LES ARGUMENTS SONT MAUVAIS */
/*     (ILS NE PERMETTENT PAS DE RECONNAITRE L'ALLOCATION DANS LA TABLE) 
*/

/*     Lorsque l'allocation est detruite, l'IOFSET correspondant est mis 
*/
/*     a 2 147 483 647. Ainsi, si on accede au tableau via l'IOFSET, un */
/*     trap se produira. Ceci permet de verifier qu'on ne se sert plus */
/*     d'une zone de memoire qu'on a liberee. Cette verification n'est */
/*     valable que si c'est le meme sous-programme qui utilise et qui */
/*     detruit l'allocation. */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*    05-03-93 : FCR : DMSF52088 : On prend les memes et on recommence ...
*/
/*                      IERCOD = 3 et I4UND. */
/*     22-02-93 : FCR : Pour TOYOTA : Desactivation de l'affectation de */
/*                      l'IOFSET a I4UND et suppression de IERCOD = 3. */
/*     10-02-93 : FCR ; DMSFRO253 : Ajout d'un appel a MAERMSG si IERCOD 
*/
/*                      = 3 */
/*     22-01-93 : FCR ; DMSF52088 : Ajout de l'IERCOD 3. */
/*                      Ajout de l'IOFSET mis a I4UND lorsque */
/*                      l'allocation est detruite. */
/*     08-10-92 : FCR ; DMSFRO131 : Modif pour DEBUG-ALLOC */
/*     08-09-92 : FCR ; Optimisation */
/*     18-11-91 : DGZ ; APPEL MACRCHK EN PHASE DE DEVELOPPEMENT */
/*     23-09-91 : DGZ ; RENOMME EN .FOR ET MODIFS DE COMMENTAIRES */
/*     14-05-91 : DGZ ; SUPPRIME L'OPTION /CHECK=NBOUNDS */
/*     21-08-90 : DGZ ; AFFICHAGE DU TRACE-BACK EN PHASE DE PRODUCTION */
/*                      ET RENOMME EN .VAX */
/*     22-12-89 : DGZ ; CORRECTION DE L'EN-TETE */
/*     04-11-89 : CR ; AJOUT DE OPTIONS /CHECK=NOBOUNDS. */
/*     11-05-89 : DGZ; CONTROLE DEBORDEMENT DE MEMOIRE */
/*     27-06-88 : PP ; VIRE 9001 INUTILISE */
/*     PP 26.2.88 CHANGE LE VFORMA EN MACRMSG, POUR USAGE DANS C */
/*     09-01-87 : BF ; ALLOCATIONS SYSTEME */
/*     03-11-86 : BF ; RAJOUTE STATISTIQUES */
/*     09-12-85 : BF ; UTILISE LES ROUTINES STANDARDS */
/*     09-12-85 : BF ; PLUS D'ERREUR SI L'ALLOCATION N'EXISTE PAS */
/*     07-11-85 : BF ; VERSION D'ORIGINE */
/* > */
/* ***********************************************************************
 */

/* COMMON DES PARAMETRES */

/* COMMON DES STATISTIQUES */
/*     INCLUDE MCRGENE */
/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*        TABLE DE GESTION DES ALLOCATIONS DYNAMIQUES DE MEMOIRE */

/*     MOTS CLES : */
/*     ----------- */
/*        SYSTEME, MEMOIRE, ALLOCATION */

/*     DEMSCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*       23-11-93 : FCR; AF93125U3A007 : MAXCR 200 --> 1000 */
/*       08-10-92 : FCR; DMSFRO131 : Modif pour DEBUG-ALLOC */
/*       25-09-91 : DGZ; AJOUT INFOs SUPPLEMENTAIREs POUR GESTION FLAGS */
/*       18-01-91 : DGZ; MAXCR PASSE DE 100 A 200 SUR DEMANDE GDD */
/*       18-05-90 : DGZ; DECLARATION TYPE INTEGER POUR MAXCR */
/*       20-06-88 : PP ; MAXCR PASSE DE 50 A 100, SUR DEMANDE OG */
/*                       + AJOUT DE COMMENTAIRES */
/*       26-02-88 : PP ; MAXCR PASSE DE 40 A 50, SUR DEMANDE AB . */
/*       15-04-85 : BF ; VERSION D'ORIGINE */
/* > */
/* ***********************************************************************
 */

/*   ICORE : TABLE DES ALLOCS EXISTANTES, AVEC POUR CHACUNE : */
/*         1 : NIVEAU DE PROTECTION (0=PAS PROTEGE, AUTRE=PROTEGE) */
/*             (PROTEGE SIGNIFIE PAS DETRUIT PAR CRRSET .) */
/*         2 : UNITE D'ALLOCATION */
/*         3 : NB D'UNITES ALLOUEES */
/*         4 : ADRESSE DE REFERENCE DU TABLEAU */
/*         5 : IOFSET */
/*         6 : NUMERO ALLOCATION STATIQUE */
/*         7 : Taille demandee en allocation */
/*         8 : adresse du debut de l'allocation */
/*         9 : Taille de la ZONE UTILISATEUR */
/*        10 : ADRESSE DU FLAG DE DEBUT */
/*        11 : ADRESSE DU FLAG DE FIN */
/*        12 : Rang de creation de l'allocation */

/*   NDIMCR : NBRE DE DONNEES DE CHAQUE ALLOC DANS ICORE */
/*   NCORE : NBRE D'ALLOCS EN COURS */
/*   LPROT : COMMUNICATION ENTRE CRPROT ET MCRRQST, REMIS A 0 PAR MCRRQST 
*/
/*   FLAG  : VALEUR DU FLAG UTILISE POUR LES DEBORDEMENTS */



/* ----------------------------------------------------------------------*
 */


/*     20-10-86 : BF ; VERSION D'ORIGINE */


/*     NRQST : NOMBRE D'ALLOCATIONS EFFECTUEES */
/*     NDELT : NOMBRE DE LIBERATIONS EFFECTUEES */
/*     NBYTE : NOMBRE TOTAL D'OCTETS DES ALLOCATIONS */
/*     MBYTE : NOMBRE MAXI D'OCTETS */

    /* Parameter adjustments */
    --t;

    /* Function Body */
    *iercod = 0;

/* RECHERCHE DANS MCRGENE */

    n = 0;
    mcrlocv_(&t[1], &loc);

    for (i__ = mcrgene_1.ncore; i__ >= 1; --i__) {
	if (*iunit == mcrgene_1.icore[i__ * 12 - 11] && *isize == 
		mcrgene_1.icore[i__ * 12 - 10] && loc == mcrgene_1.icore[i__ *
		 12 - 9] && *iofset == mcrgene_1.icore[i__ * 12 - 8]) {
	    n = i__;
	    goto L1100;
	}
/* L1001: */
    }
L1100:

/* SI L'ALLOCATION N'EXISTE PAS , ON SORT */

    if (n <= 0) {
	goto L9003;
    }

/* ALLOCATION RECONNUE : ON RECUPERE LES AUTRES INFOS */

    ksys = mcrgene_1.icore[n * 12 - 7];
    ibyte = mcrgene_1.icore[n * 12 - 6];
    iaddr = mcrgene_1.icore[n * 12 - 5];
    iadfd = mcrgene_1.icore[n * 12 - 3];
    iadff = mcrgene_1.icore[n * 12 - 2];
    nrang = mcrgene_1.icore[n * 12 - 1];

/*     Controle des flags */

    madbtbk_(&iver);
    if (iver == 1) {
	macrchk_();
    }

    if (ksys <= 1) {
/* DE-ALLOCATION SUR COMMON */
	kop = 2;
	mcrcomm_(&kop, &ibyte, &iaddr, &ier);
	if (ier != 0) {
	    goto L9001;
	}
    } else {
/* DE-ALLOCATION SYSTEME */
	mcrfree_(&ibyte, &iaddr, &ier);
	if (ier != 0) {
	    goto L9002;
	}
    }

/* APPEL PERMETTANT LE CANCEL WATCH AUTOMATQUE PAR LE DEBUGGER */

    macrclw_(&iadfd, &iadff, &nrang);

/* MISE A JOUR DES STATISTIQUES */
    if (ksys <= 1) {
	i__ = 1;
    } else {
	i__ = 2;
    }
    ++mcrstac_1.ndelt[i__ - 1];
    mcrstac_1.nbyte[i__ - 1] -= mcrgene_1.icore[n * 12 - 11] * 
	    mcrgene_1.icore[n * 12 - 10];

/* SUPPRESSION DES PARAMETRES DANS MCRGENE */
    if (n < 1000) {
/*	noct = (mcrgene_1.ncore - n) * 48; */
        noct = (mcrgene_1.ncore - n) * 12 * sizeof(long int);
	mcrfill_(&noct, &mcrgene_1.icore[(n + 1) * 12 - 12], &mcrgene_1.icore[
		n * 12 - 12]);
    }
    --mcrgene_1.ncore;

/* *** Mise a l'overflow de l'IOFSET */
    *iofset = 2147483647;
    goto L9900;

/* ----------------------------------------------------------------------*
 */
/*     TRAITEMENT DES ERREURS */

L9001:
/*  REFUS DE DE-ALLOCATION PAR LA ROUTINE 'MCRCOMM' (ALLOC DS COMMON) */
    *iercod = 1;
    maermsg_("MCRDELT", iercod, 7L);
    maostrd_();
    goto L9900;

/*  REFUS DE DE-ALLOCATION PAR LE SYSTEME */
L9002:
    *iercod = 2;
    maermsg_("MCRDELT", iercod, 7L);
    macrmsg_("MCRDELT", iercod, &ibid, &xbid, " ", 7L, 1L);
    maostrd_();
    goto L9900;

/* ALLOCATION INEXISTANTE */
L9003:
    *iercod = 3;
    maermsg_("MCRDELT", iercod, 7L);
    maostrd_();
    goto L9900;

L9900:

 return 0   ;

} /* mcrdelt_ */

