/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPProtocol.h

	Contains:	A grouping of static utilities that abstract keyword strings
				in the RTSP protocol. This should be maintained as new versions
				of the RTSP protoocl appear & as the server evolves to take
				advantage of new RTSP features.

	$Log: RTSPProtocol.h,v $
	Revision 1.2  1999/02/19 23:08:31  ds
	Created
	

*/


#ifndef __RTSPPROTOCOL_H__
#define __RTSPPROTOCOL_H__

#include "StrPtrLen.h"

class RTSPProtocol {
public:

	//METHODS
	
	//Enumerated type for rtsp methods
	enum
	{
		kDescribeMethod		= 0, 
		kSetupMethod		= 1,
		kTeardownMethod		= 2,
		kNumVIPMethods 		= 3,

		kPlayMethod			= 3,
		kPauseMethod		= 4,
		kOptionsMethod		= 5,
		kAnnounceMethod		= 6,
		kGetParameterMethod	= 7,
		kSetParameterMethod	= 8,
		kRedirectMethod		= 9,
		kRecordMethod		= 10,
		kIllegalMethod		= 11
	};
	typedef UInt32 RTSPMethod;
	
	//The lookup function. Very simple
	static RTSPMethod	GetMethod(const StrPtrLen &inMethodStr);
	
	//HEADERS
	enum
	{
		//These are the common request headers (optimized)
		kAcceptHeader		 	= 0,
		kCSeqHeader		 		= 1,
		kUserAgentHeader		= 2,
		kTransportHeader		= 3,
		kSessionHeader			= 4,
		kRangeHeader			= 5,
		kNumVIPHeaders 			= 6,
		
		//Other request headers
		kAcceptEncodingHeader 	= 6,
		kAcceptLanguageHeader 	= 7,
		kAuthorizationHeader 	= 8,		
		kBandwidthHeader 		= 9,
		kBlockSizeHeader	 	= 10,
		kCacheControlHeader 	= 11,
		kConferenceHeader 		= 12,		
		kConnectionHeader 		= 13,
		kContentBaseHeader 		= 14,
		kContentEncodingHeader 	= 15,
		kContentLanguageHeader 	= 16,
		kContentLengthHeader 	= 17,
		kContentLocationHeader 	= 18,
		kContentTypeHeader 		= 19,
		kDateHeader		 		= 20,
		kExpiresHeader	 		= 21,
		kFromHeader		 		= 22,
		kHostHeader		 		= 23,
		kIfMatchHeader			= 24,
		kIfModifiedSinceHeader	= 25,
		kLastModifiedHeader		= 26,
		kLocationHeader			= 27,
		kProxyAuthenticateHeader= 28,
		kProxyRequireHeader		= 29,
		kRefererHeader			= 30,
		kRetryAfterHeader		= 31,
		kRequireHeader			= 32,
		kRTPInfoHeader			= 33,
		kScaleHeader			= 34,
		kSpeedHeader			= 35,
		kTimestampHeader		= 36,
		kVaryHeader				= 37,
		kViaHeader				= 38,
		kNumRequestHeaders 		= 39,
		
		//Additional response headers
		kAllowHeader	 		= 39,
		kPublicHeader			= 40,
		kServerHeader			= 41,
		kUnsupportedHeader		= 42,
		kWWWAuthenticateHeader	= 43,
		kSameAsLastHeader		= 44,
		kIllegalHeader 			= 45
	};
	typedef UInt32 RTSPHeader;

	//The lookup function. Very simple
	static RTSPHeader GetRequestHeader(const StrPtrLen& inHeaderStr);
	
	//The lookup function. Very simple.
	static StrPtrLen& GetHeaderString(RTSPHeader inHeader)
		{ return sHeaders[inHeader]; }
	
	
	//STATUS CODES
	enum
	{
		kContinue						= 0,		//100
 		kSuccessOK 						= 1,		//200
 		kSuccessCreated 				= 2,		//201
 		kSuccessAccepted 				= 3,		//202
 		kSuccessNoContent 				= 4,		//203
 		kSuccessPartialContent 			= 5,		//204
 		kSuccessLowOnStorage 			= 6,		//250
 		kMultipleChoices 				= 7,		//300
	 	kRedirectPermMoved 				= 8,		//301
 		kRedirectTempMoved				= 9,		//302
 		kRedirectSeeOther				= 10,		//303
 		kRedirectNotModified 			= 10,		//304
 		kUseProxy 						= 12,		//305
 		kClientBadRequest 				= 13,		//400
 		kClientUnAuthorized 			= 14,		//401
		kPaymentRequired				= 15,		//402
 		kClientForbidden 				= 16,		//403
 		kClientNotFound 				= 17,		//404
 		kClientMethodNotAllowed			= 18,		//405
 		kNotAcceptable					= 19,		//406
 		kProxyAuthenticationRequired	= 20,		//407
 		kRequestTimeout					= 21,		//408
 		kClientConflict					= 22,		//409
 		kGone							= 23,		//410
 		kLengthRequired					= 24,		//411
 		kPreconditionFailed				= 25,		//412
 		kRequestEntityTooLarge			= 26,		//413
 		kRequestURITooLarge				= 27,		//414
 		kUnsupportedMediaType			= 28,		//415
 		kClientParameterNotUnderstood	= 29,		//451
 		kClientConferenceNotFound		= 30,		//452
 		kClientNotEnoughBandwidth		= 31,		//453
 		kClientSessionNotFound			= 32,		//454
 		kClientMethodNotValidInState	= 33,		//455
 		kClientHeaderFieldNotValid		= 34,		//456
 		kClientInvalidRange				= 35,		//457
 		kClientReadOnlyParameter		= 36,		//458
 		kClientAggregateOptionNotAllowed= 37,		//459
 		kClientAggregateOptionAllowed	= 38,		//460
 		kClientUnsupportedTransport		= 39,		//461
 		kClientDestinationUnreachable	= 40,		//462
 		kServerInternal 				= 41,		//500
 		kServerNotImplemented 			= 42,		//501
 		kServerBadGateway 				= 43,		//502
 		kServerUnavailable 				= 44,		//503
 		kServerGatewayTimeout			= 45,		//505
 		kRTSPVersionNotSupported		= 46,		//504
 		kServerOptionNotSupported		= 47,		//551
 		kNumStatusCodes					= 48
	};
	typedef UInt32 RTSPStatusCode;

	//returns name of this error
	static StrPtrLen& 		GetStatusCodeString(RTSPStatusCode inStat)
		{ return sStatusCodeStrings[inStat]; }
	//returns error number for this error
	static SInt32			GetStatusCode(RTSPStatusCode inStat)
		{ return sStatusCodes[inStat]; }
	//returns error number as a string
	static StrPtrLen&		GetStatusCodeAsString(RTSPStatusCode inStat)
		{ return sStatusCodeAsStrings[inStat]; }
	
	//VERSIONS
	enum RTSPVersion
	{
		k10Version = 0,
		kIllegalVersion = 1
	};
	
	//accepts strings that look like "RTSP/1.0" etc...
	static RTSPVersion		GetVersion(StrPtrLen &versionStr);
	static StrPtrLen&		GetVersionString(RTSPVersion version)
		{ return sVersionString[version]; }
	
private:

	//for other lookups
	static StrPtrLen			sMethods[];
	static StrPtrLen			sHeaders[];
	static StrPtrLen			sStatusCodeStrings[];
	static StrPtrLen			sStatusCodeAsStrings[];
	static SInt32				sStatusCodes[];
	static StrPtrLen 			sVersionString[];
	static SInt8				sMapStatusCodeToLogString[];
	
	
};
#endif // __RTSPPROTOCOL_H__
