/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPSessionInterface.cpp

	Contains:	Implementation of RTSPSessionInterface object.
	
	$Log: RTSPSessionInterface.cpp,v $
	Revision 1.2  1999/02/19 23:08:38  ds
	Created
	

*/

#include "atomic.h"

#include "RTSPSessionInterface.h"
#include "RTSPServerInterface.h"



													
static DictValueIDManager sRTSPSessionDictValueIDManager;

unsigned int RTSPSessionInterface::sSessionIDCounter = kFirstRTSPSessionID;


UInt32 RTSPSessionInterface::GenerateDictionaryID(FourCharCode inValueSignature)
{
	return sRTSPSessionDictValueIDManager.GenerateIDForSignature(inValueSignature);
}

RTSPSessionInterface::RTSPSessionInterface() : 
	Task(), 
	Dictionary(&sRTSPSessionDictValueIDManager),
	fCookieA(NULL),
	fCookieB(NULL),
	fStream(&fSocket),
	fLiveSession(true),
	fSocket(Socket::kNonBlocking | Socket::kWantsEvents, this),
	fTimeoutEnabled(true)
{
	fSessionID = (UInt32)atomic_add(&sSessionIDCounter, 1);
}



