class Puits
  parameter Real P0=100000 "Pression du puits";
  parameter Real T0=290"Temprature du puits";
  parameter Real H0=100000 "Enthalpie spcifique du puits";
  parameter Real option_temperature=1 "1:temprature fixe - 2:enthalpie fixe";

  Real Pm "Pression moyenne";
  Real Q "Dbit";
  Real Tm "Temprature moyenne";
  Real Hm "Enthalpie spcifique moyenne";

public 
  PortPHQ1 C ;
equation 
  
  C.P = Pm;
  C.Q = Q;
  C.Hm = Hm;

  Pm = P0;
  Hm= H0;

  
  Tm = if (option_temperature <= 1) then T0 else Hm/4187 + 273.15;

end Puits;
