package test.contrib;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class CustomTableBackgroundMetal {

	public static class Blip extends JPanel {
		public static void main(String[] args) throws Exception {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					showMe();
				}
			});
		}

		public static void showMe() {
			JFrame frame = new JFrame("FFFFFFF");
			frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			final JMenuBar menuBar = new JMenuBar();
			final JMenu menu = new JMenu("Exit");
			final JMenuItem item = new JMenuItem("Exit", UIManager
					.getIcon("OptionPane.errorIcon"));
			item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					System.exit(0);
				}
			});
			menu.add(item);
			menuBar.add(menu);
			frame.setJMenuBar(menuBar);
			final Container contentPane = frame.getContentPane();
			contentPane.setLayout(new BorderLayout());
			contentPane.add(createTable("Some table"), BorderLayout.NORTH);
			frame.setSize(500, 200);
			frame.setVisible(true);
		}

		private static JPanel createTable(String s) {
			final JTable table = new JTable();
			table.setModel(new DefaultTableModel(new Object[][] {
					new Object[] { s, s }, new Object[] { s, s },
					new Object[] { s, s }, new Object[] { s, s }, },
					new Object[] { "DDDDDD", "DDDDD" }));
			table.setOpaque(false);
			table.setDefaultRenderer(String.class,
					new DefaultTableCellRenderer() {
						@Override
						public Component getTableCellRendererComponent(
								JTable table, Object value, boolean isSelected,
								boolean hasFocus, int row, int column) {
							final JLabel rendererComponent = (JLabel) super
									.getTableCellRendererComponent(table,
											value, isSelected, hasFocus, row,
											column);
							rendererComponent.setOpaque(false);
							return rendererComponent;
						}
					});
			final JPanel panel = new JPanel(new BorderLayout());
			panel.setBackground(Color.YELLOW);
			panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
			panel.add(table, BorderLayout.CENTER);
			return panel;
		}

	}
}
