/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    public int handle;
    Tree parent;
    int background;
    int foreground;
    int font;

    public TreeItem(Tree tree, int n) {
        super(tree, n);
        this.parent = tree;
        tree.createItem(this, 0, -65534);
    }

    public TreeItem(Tree tree, int n, int n2) {
        super(tree, n);
        if (n2 < 0) {
            this.error(6);
        }
        this.parent = tree;
        int n3 = -65535;
        if (n2 != 0) {
            int n4 = 1;
            int n5 = tree.handle;
            n3 = OS.SendMessage(n5, 4362, 0, 0);
            while (n3 != 0 && n4 < n2) {
                n3 = OS.SendMessage(n5, 4362, 1, n3);
                ++n4;
            }
            if (n3 == 0) {
                this.error(6);
            }
        }
        tree.createItem(this, 0, n3);
    }

    public TreeItem(TreeItem treeItem, int n) {
        super(TreeItem.checkNull((TreeItem)treeItem).parent, n);
        this.parent = treeItem.parent;
        int n2 = treeItem.handle;
        this.parent.createItem(this, n2, -65534);
    }

    public TreeItem(TreeItem treeItem, int n, int n2) {
        super(TreeItem.checkNull((TreeItem)treeItem).parent, n);
        if (n2 < 0) {
            this.error(6);
        }
        this.parent = treeItem.parent;
        int n3 = -65535;
        int n4 = treeItem.handle;
        if (n2 != 0) {
            int n5 = 1;
            int n6 = this.parent.handle;
            n3 = OS.SendMessage(n6, 4362, 4, n4);
            while (n3 != 0 && n5 < n2) {
                n3 = OS.SendMessage(n6, 4362, 1, n3);
                ++n5;
            }
            if (n3 == 0) {
                this.error(6);
            }
        }
        this.parent.createItem(this, n4, n3);
    }

    static TreeItem checkNull(TreeItem treeItem) {
        if (treeItem == null) {
            SWT.error(4);
        }
        return treeItem;
    }

    void _setText(String string) {
        int n = this.parent.handle;
        int n2 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), string, true);
        int n3 = tCHAR.length() * TCHAR.sizeof;
        int n4 = OS.HeapAlloc(n2, 8, n3);
        OS.MoveMemory(n4, tCHAR, n3);
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 17;
        tVITEM.hItem = this.handle;
        tVITEM.pszText = n4;
        OS.SendMessage(n, OS.TVM_SETITEM, 0, tVITEM);
        OS.HeapFree(n2, 0, n4);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Color getBackground() {
        this.checkWidget();
        int n = this.background == -1 ? this.parent.getBackgroundPixel() : this.background;
        return Color.win32_new(this.display, n);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int n = this.parent.handle;
        RECT rECT = new RECT();
        rECT.left = this.handle;
        if (OS.SendMessage(n, 4356, 1, rECT) == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    public boolean getChecked() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int n = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        int n2 = OS.SendMessage(n, OS.TVM_GETITEM, 0, tVITEM);
        return n2 != 0 && (tVITEM.state >> 12 & 1) == 0;
    }

    public boolean getExpanded() {
        this.checkWidget();
        int n = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.hItem = this.handle;
        tVITEM.mask = 8;
        OS.SendMessage(n, OS.TVM_GETITEM, 0, tVITEM);
        return (tVITEM.state & 0x20) != 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font == -1 ? this.parent.getFont() : Font.win32_new(this.display, this.font);
    }

    public Color getForeground() {
        this.checkWidget();
        int n = this.foreground == -1 ? this.parent.getForegroundPixel() : this.foreground;
        return Color.win32_new(this.display, n);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int n = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        int n2 = OS.SendMessage(n, OS.TVM_GETITEM, 0, tVITEM);
        return n2 != 0 && tVITEM.state >> 12 > 2;
    }

    public int getItemCount() {
        this.checkWidget();
        int n = this.parent.handle;
        int n2 = OS.SendMessage(n, 4362, 4, this.handle);
        if (n2 == 0) {
            return 0;
        }
        return this.parent.getItemCount(n2);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        int n = this.parent.handle;
        int n2 = OS.SendMessage(n, 4362, 4, this.handle);
        if (n2 == 0) {
            return new TreeItem[0];
        }
        return this.parent.getItems(n2);
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        int n = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        tVITEM.hItem = OS.SendMessage(n, 4362, 3, this.handle);
        if (tVITEM.hItem == 0) {
            return null;
        }
        OS.SendMessage(n, OS.TVM_GETITEM, 0, tVITEM);
        return this.parent.items[tVITEM.lParam];
    }

    void redraw() {
        if (this.parent.drawCount > 0) {
            return;
        }
        int n = this.parent.handle;
        if (!OS.IsWindowVisible(n)) {
            return;
        }
        RECT rECT = new RECT();
        rECT.left = this.handle;
        if (OS.SendMessage(n, 4356, 1, rECT) != 0) {
            OS.InvalidateRect(n, rECT, true);
        }
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n = color.handle;
        }
        if (this.background == n) {
            return;
        }
        this.background = n;
        this.redraw();
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        int n = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        OS.SendMessage(n, OS.TVM_GETITEM, 0, tVITEM);
        int n2 = tVITEM.state >> 12;
        if (bl) {
            if ((n2 & 1) != 0) {
                ++n2;
            }
        } else if ((n2 & 1) == 0) {
            --n2;
        }
        tVITEM.state = n2 << 12;
        OS.SendMessage(n, OS.TVM_SETITEM, 0, tVITEM);
    }

    public void setExpanded(boolean bl) {
        this.checkWidget();
        int n = this.parent.handle;
        int n2 = OS.SendMessage(n, 4362, 9, 0);
        this.parent.ignoreExpand = true;
        OS.SendMessage(n, 4354, bl ? 2 : 1, this.handle);
        this.parent.ignoreExpand = false;
        int n3 = OS.SendMessage(n, 4362, 9, 0);
        if (n3 != n2) {
            Event event = new Event();
            if (n3 != 0) {
                TVITEM tVITEM = new TVITEM();
                tVITEM.mask = 20;
                tVITEM.hItem = n3;
                if (OS.SendMessage(n, OS.TVM_GETITEM, 0, tVITEM) != 0) {
                    event.item = this.parent.items[tVITEM.lParam];
                }
                this.parent.hAnchor = n3;
            }
            this.parent.sendEvent(13, event);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n = -1;
        if (font != null) {
            this.parent.customDraw = true;
            n = font.handle;
        }
        if (this.font == n) {
            return;
        }
        this.font = n;
        this._setText(this.text);
        this.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n = color.handle;
        }
        if (this.foreground == n) {
            return;
        }
        this.foreground = n;
        this.redraw();
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        int n = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        OS.SendMessage(n, OS.TVM_GETITEM, 0, tVITEM);
        int n2 = tVITEM.state >> 12;
        if (bl) {
            if (n2 <= 2) {
                n2 += 2;
            }
        } else if (n2 > 2) {
            n2 -= 2;
        }
        tVITEM.state = n2 << 12;
        OS.SendMessage(n, OS.TVM_SETITEM, 0, tVITEM);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.type == 1 && image.equals(this.image)) {
            return;
        }
        super.setImage(image);
        int n = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 50;
        tVITEM.iSelectedImage = tVITEM.iImage = this.parent.imageIndex(image);
        tVITEM.hItem = this.handle;
        OS.SendMessage(n, OS.TVM_SETITEM, 0, tVITEM);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        this._setText(string);
    }
}

