/* remember to link with list.o!!!!!!!!!!!!!!! */

typedef void *titem;	/* one of the things listed below */
typedef void *targs;	/* holds the parsed versions of the command line
							paramaters */

/* can be on the root window, parent NULL */
typedef void *tframe;	/* a frame */

/* can be on a frame */
typedef void *tcanvas;	/* a scrollable (2directions) window with zoomin/out,
							that can be printed */
typedef void *tlist;	/* a scrollable list of items to choose from */
typedef void *tlistitem;/* an item in a tlist */
typedef void *tpanel;	/* a panel of objects, types of which are below */

/* can be on a panel */
typedef void *tpbutton;
typedef void *tpcheck; 	/* a single checkbox */
typedef void *tpslider;
typedef void *tpchoice;
typedef void *tpstack;
typedef void *tptext;
typedef void *tpmsg;
typedef void *tpmenu;	/* menu, with a button, unless it's parent is a
							menuitem, then it's a subment */

/* misc */
typedef void *tpitem;	/* an item on a menu or choice */

/* drawing objects */
typedef void *tdisplay;	/* a display */
typedef void *twindow;	/* a window */
typedef void *tevent;	/* an event */
typedef void *tfont;	/* a font */
typedef void *tfontname;	/* the name of a font family */
typedef void *tfontstyle;	/* a style for a font */
typedef void *tfontsize;	/* a size for a font */
typedef void *tcontext;	/* a graphics context */
typedef void *tcolor;	/* a color */
typedef void *tpic;		/* an off screen picture */
typedef void *tcursor;	/* a cursor */
typedef void *ttext;	/* tobject, an area of text on a maincvs */
typedef void *tload;	/* file load chooser */
typedef void *tsave;	/* file save chooser */
typedef void *tcolorchooser;

typedef enum {
	/* window,canvas,frame events */
	te_repaint,		/* need to redraw */
	te_resize,		/* was resized */
	te_mousedown,	/* mouse button was pushed */
	te_mouseup,		/* mouse button was released */
	te_drag,		/* mouse moved with button down */
	te_move,		/* mouse moved with buttons up */
	te_keydown,		/* key was pushed */
	te_keyup,		/* key was released */
	te_enter,		/* mouse entered item */
	te_exit,		/* mouse exited item */
	te_destroy,		/* item is being destroyed, can still veto */
	te_create,		/* frame is created */
	te_done,		/* command frame is going away */
	/* panel item events */
	te_tpbutton,	/* panel button pushed */
	te_tpslider,	/* slider moved (or value entered) */
	te_tpchoice,	/* new choice selected */
	te_tpstack,	/* new choice selected */
	te_tptext,		/* text changed */
	te_tpmenu,		/* menu item selected */
	te_user,		/* user event */
	te_unknown
	} type_tevent;

typedef enum {
	/* special keys */
	tk_left,
	tk_right,
	tk_down,
	tk_up,
	tk_page_up,
	tk_page_down,
	tk_delete,
	tk_cut,			/* cut,copy,paste,undo pressed */
	tk_copy,
	tk_paste,
	tk_undo,
	tk_help,
	tk_none
	} special_key;

/* buttons */
typedef enum {
	tb_select,
	tb_adjust,
	tb_menu,
	tb_4,
	tb_5,
	tb_none
	} t_button;

/* modifiers */
typedef enum {
	tm_shift,
	tm_ctrl,
	tm_meta,
	tm_none
	} t_modifier;

typedef enum {
	tc_copy,
	tc_xor,
	tc_or,
	tc_clear
	} tc_function;

typedef enum {
	tp_postscript,
	tp_PICT,
	tp_none
	} tp_type;

typedef enum {
    NW,
    N,
    NE,
    E,
    SE,
    S,
    SW,
    W,
    CENTER,
    NONE
    } direction;

typedef enum {
	tptext_next,
	tptext_previous,
	tptext_insert,
	tptext_none,
	tptext_dontknow
	} tptext_action;

typedef enum {
	tcap_notlast,
	tcap_butt,
	tcap_round,
	tcap_projecting,
	tcap_none
	} tcap_style;

typedef enum {
	tfill_solid,
	tfill_tiled,
	tfill_stippled,
	tfill_opaquestippled,
	tfill_none
	} tfill_style;

/* Functions: */
/* calling routine for startup

	args=targs_parse(&argc,argv);

	if(!tinitialize(args))
		printf("Error, cannot startup!\n");

	if((frame=tframe_new(dpy, 10, 10, 500, 500,
							1, 0, 1, "NewFrame", args))==NULL)
		printf("Error, cannot create frame!\n");
	
	if(!tfont_list(frame, &name,&style,&size))
		printf("Error, cannot find any fonts\n");
	
	continue, creating panels, canvases, etc...

	tframe_loop(frame);
*/

extern targs targs_parse();
extern int targs_free();
extern int *targs_argc_ptr();
extern char **targs_argv();
extern tcolor tcanvas_Black();
extern tcolor tcanvas_White();
extern tdisplay tcanvas_display();
extern int tcanvas_right_side();
extern int tcanvas_bottom_side();
extern int size_to_cvs();
extern int point_to_cvs();
extern int size_to_norm();
extern int point_to_norm();
extern int size_to_x();
extern int point_to_x();
extern int tcanvas_center_x();
extern int tcanvas_center_y();
extern void dorepaintcvs();
extern int tcanvas_pop_buffer();
extern int tcanvas_magnification();
extern int tcanvas_zoom_in();
extern int tcanvas_zoom_out();
extern int tcanvas_zoom_level();
extern int tcanvas_move();
extern int tcanvas_resize();
extern int tcanvas_pages();
extern void scrollcvs();
extern void tcanvas_scroll_down();
extern void tcanvas_scroll_up();
extern void tcanvas_scroll_to_top();
extern void tcanvas_scroll_right();
extern void tcanvas_scroll_left();
extern void tcanvas_set_canvas_width();
extern void tcanvas_set_canvas_height();
extern int tcanvas_point_on_screen();
extern int tcanvas_point_above_screen();
extern int tcanvas_point_below_screen();
extern void tcanvas_move_point_on_screen();
extern void tcanvas_events();
extern void tcanvas_repaint();
extern int tcanvas_refresh();
extern void scroll_compute();
extern tcanvas tcanvas_new2();
extern int tcanvas_free();
extern tcanvas tcanvas_new_no_scrollbars();
extern tcanvas tcanvas_new();
extern int tcanvas_set_event_procedure();
extern int tcanvas_set_area();
extern int tcanvas_in_area();
extern int tcanvas_set_clipping();
extern int tcanvas_start_printing();
extern int tcanvas_stop_printing();
extern int tcanvas_is_printing();
extern FILE *tcanvas_print_file();
extern int tcanvas_get_pointer();
extern int tcanvas_add_all();
extern int tcanvas_add_area();
extern int tcanvas_reset_area();
extern tcanvas_clear_area();
extern int tcanvas_paint_area();
extern int tcanvas_clipping_on();
extern int tcanvas_clipping_off();
extern int tcanvas_sync();
extern int tcanvas_grab_pointer();
extern int tcanvas_ungrab_pointer();
extern int tcanvas_add_handle();
extern int tcanvas_height();
extern int tcanvas_width();
extern int tcanvas_do_timer();
extern int tcanvas_start_timer();
extern int tcanvas_stop_timer();
extern tcolor tcolor_new();
extern int tcolor_free();
extern int tcolor_values();
extern tcolor tcolor_black();
extern tcolor tcolor_white();
extern unsigned long tcolor_Xpixel();
extern tcolor_change_red();
extern tcolor_change_green();
extern tcolor_change_blue();
extern tcolor_choose_ok();
extern int draw_colored_square();
extern int enter_color_name();
extern tcolor_change_chooser_color();
extern tcolorchooser tcolor_new_chooser();
extern int tcolor_hide_chooser();
extern int tcolor_show_chooser();
extern int tcolor_move_chooser();
extern tcontext tcontext_new();
extern int tcontext_free();
extern int tcontext_xcap_style();
extern int tcontext_set_foreground();
extern int tcontext_set_background();
extern int tcontext_set_function();
extern int tcontext_set_linewidth();
extern int tcontext_set_fillstyle();
extern int tcontext_set_stipple();
extern int tcontext_set_capstyle();
extern int tcontext_set_solid();
extern int tcontext_set_dashes();
extern int tcontext_set_font();
extern int tcontext_set_cliparea();
extern int tcontext_set_noclipping();
extern int tcontext_get_foreground();
extern int tcontext_get_background();
extern int tcontext_get_function();
extern int tcontext_get_linewidth();
extern int tcontext_get_fillstyle();
extern int tcontext_get_stipple();
extern int tcontext_get_capstyle();
extern int tcontext_get_solid();
extern int tcontext_get_dashes();
extern int tcontext_get_font();
extern int tcontext_get_cliparea();
extern tcontext tcontext_copy();
extern tcursor tcursor_new();
extern int tcursor_set();
extern int tcursor_unset();
extern tdisplay tdisplay_new();
extern tdisplay tdisplay_create_from_xdpy();
extern int tdisplay_free();
extern int tdisplay_XScreen();
extern tcolor tdisplay_Black();
extern tcolor tdisplay_White();
extern int tdisplay_depth();
extern double tdisplay_dpi_x();
extern double tdisplay_dpi_y();
extern tdisplay_beep();
extern setup_gc();
extern draw_text();
extern draw_text_transparent();
extern draw_arc();
extern draw_line();
extern drag_line();
extern draw_rect();
extern draw_filled_rect();
extern draw_clear_rect();
extern draw_square_handle();
extern draw_filled_square_handle();
extern draw_x_handle();
extern draw_circle_handle();
extern draw_filled_circle_handle();
extern drag_square_handle();
extern drag_x_handle();
extern drag_circle_handle();
extern drag_rectangle();
extern int in_handle();
extern tevent tevent_create_from_xviewevent();
extern type_tevent tevent_type();
extern int tevent_location();
extern int tevent_size();
extern int tevent_area();
extern t_button tevent_button();
extern special_key tevent_special_key();
extern char *tevent_string();
extern int tevent_button_down();
extern int tevent_modifier_down();
extern tevent tevent_create_user();
extern tevent_free();
extern tevent tevent_create_repaint();
extern tevent tevent_create_done();
extern int tevent_xview_x();
extern int tevent_xview_y();
extern int tfont_gogetachar();
extern int tfont_skipspace();
extern char *tfont_read_fname();
extern int tfont_read_num();
extern int tfontname_free();
extern int tfontstyle_free();
extern int tfontsize_free();
extern int tfont_list();
extern tfontname tfont_get_name_from_item();
extern tfontstyle tfont_get_style_from_item();
extern tfontsize tfont_get_size_from_item();
extern tpchoice tfont_make_name_choicemenu();
extern tpchoice tfont_make_style_choicemenu();
extern tpchoice tfont_make_size_choicemenu();
extern int tfont_grey_menus();
extern tfont tfont_new();
extern tfont tfont_create_from_fontname();
extern int tfont_free();
extern int tfont_get_characteristics();
extern int tfont_height();
extern int tfont_ascent();
extern int tfont_descent();
extern int tfont_text_width();
extern int tfont_get_extents();
extern int tfont_exist();
extern int tfont_set_selection();
extern tfont tfont_get_selected_font();
extern char *tfont_get_lasername();
extern int tfont_get_lasersize();
extern tfont tfont_get_font_by_names();
extern tfont tfont_get_first_font();
extern int tfont_get_mac_number();
extern int tfont_get_mac_style();
extern char *tfont_name();
extern char *tfont_style();
extern int tfont_size();
extern int tframe_loop();
extern tframe tframe_new();
extern tpanel tframe_dialog_panel();
extern int tframe_free();
extern int tframe_set_footer();
extern int tframe_show();
extern int tframe_hide();
extern int tframe_move();
extern int tframe_fit();
extern int tframe_set_event_procedure();
extern int tframe_set_destroy_procedure();
extern tdisplay tframe_display();
extern int tframe_set_min_size();
extern int tframe_push_pin();
extern int tframe_pull_pin();
extern void *tframe_notice_window();
extern void tframe_set_busy();
extern void tframe_set_notbusy();
extern void tframe_set_name();
extern int tframe_set_icon();
extern titem titem_parent();
extern int titem_set_parent();
extern titem titem_new();
extern int titem_free();
extern void *titem_get_data();
extern int titem_set_data();
extern void *titem_get_intdata();
extern int titem_set_intdata();
extern int tp_right_side();
extern int tp_bottom_side();
extern int tright_side();
extern int tbottom_side();
extern tdisplay titem_display();
extern void *titem_drawable();
extern void *titem_xview_window();
extern int tinitialize();
extern tdisplay tlist_display();
extern void *tlist_drawable();
extern int tlist_bottom_side();
extern int tlist_right_side();
extern void move_item_on_screen();
extern void get_top_and_bottom();
extern void move_list_for_selection();
extern start_list_scrolling();
extern stop_list_scrolling();
extern int handle_list();
extern void tlist_refresh();
extern tlist tlist_new();
extern int tlist_set_event_procedure();
extern void tlist_add();
extern void tlist_select();
extern void tlist_move();
extern void tlist_resize();
extern int tlist_item_greyed();
extern void *tlist_nth_data();
extern char *tlist_nth_name();
extern int tlist_selected();
extern tlist_remove_all();
extern tload_hide();
extern tload_show();
extern tload_push_pin();
extern tload_pull_pin();
extern int tload_move();
extern tload_checkdir();
extern tload_make_filelist();
extern int tload_choose_open();
extern int tload_choose_up();
extern int tload_choose_cancel();
extern int tload_choose_dirname();
extern int handle_load_frame();
extern int tload_choose_filelist();
extern tload tload_new();
extern void *tload_xview();
extern int tload_get_panel();
extern int tload_refit_panel();
extern int tload_set_busy();
extern int tload_set_notbusy();
extern rectintersect();
extern rectunion();
extern rectcpy();
extern get_corner();
extern set_corner();
extern move_corner();
extern constrain_rect_max();
extern constrain_rect_min();
extern int rect_in_rect();
extern int pt_in_rect();
extern normalize_rect();
extern void tnotice_no_choice();
extern void tnotice_no_choice_2line();
extern int tnotice_yes_no();
extern int tnotice_2line_2answer();
extern int tnotice_3line_3answer();
extern tdisplay tpanel_display();
extern int tpanel_right_side();
extern int tpanel_bottom_side();
extern tpanel tpanel_new();
extern tpanel tpanel_new_from_dialog();
extern int tpanel_free();
extern int tpanel_fit();
extern int tpanel_set_width_to_frame();
extern int tpanel_height();
extern int tpanel_width();
extern int tpbutton_right_side();
extern int tpbutton_bottom_side();
extern tpbutton tpbutton_new();
extern tpbutton tpbutton_new_image();
extern int tpbutton_free();
extern int tpbutton_enable();
extern int tpbutton_disable();
extern int tpbutton_set_event_procedure();
extern tpbutton_set_color();
extern int tpcheck_right_side();
extern int tpcheck_bottom_side();
extern int tpcheck_set();
extern int tpcheck_unset();
extern tpcheck tpcheck_new();
extern int tpcheck_free();
extern int tpcheck_enable();
extern int tpcheck_disable();
extern int tpcheck_set_event_procedure();
extern int tpchoice_right_side();
extern int tpchoice_bottom_side();
extern void tpchoicebutton_notify();
extern void tpchoice_notify();
extern tpchoice tpchoice_new();
extern int tpchoice_free();
extern int tpchoice_enable();
extern int tpchoice_disable();
extern int tpchoice_add();
extern int tpchoice_remove();
extern tpitem tpchoice_first_item();
extern tpitem tpchoice_next_item();
extern tpitem tpchoice_selected();
extern int tpchoice_disable_item();
extern int tpchoice_select_item();
extern int tpchoice_set_default_item();
extern int tpchoice_fix_width();
extern int pdraw_start();
extern int pdraw_end();
extern int pdraw_text();
extern pdraw_arc();
extern pdraw_line();
extern pdraw_rect();
extern tpic tpic_new();
extern int tpic_free();
extern void tpitem_notify();
extern tpitem tpitem_new();
extern tpitem tpitem_new_image();
extern int tpitem_free();
extern int tpitem_set_name();
extern char *tpitem_get_name();
extern int tpitem_set_image();
extern tpic tpitem_get_image();
extern void *tpitem_get_event_procedure();
extern int tpitem_set_event_procedure();
extern int tpitem_selected();
extern int tpitem_select();
extern int tpitem_unselect();
extern int tpitem_enabled();
extern int tpitem_enable();
extern int tpitem_disable();
extern int tpitem_inverted();
extern int tpitem_invert();
extern int tpitem_normal();
extern int tpitem_set_submenu();
extern int tpmenu_right_side();
extern int tpmenu_bottom_side();
extern tpmenu tpmenu_new();
extern int tpmenu_free();
extern int tpmenu_enable();
extern int tpmenu_disable();
extern int tpmenu_add();
extern int tpmenu_remove();
extern tpitem tpmenu_first_item();
extern tpitem tpmenu_next_item();
extern int tpmsg_right_side();
extern int tpmsg_bottom_side();
extern tpmsg tpmsg_new();
extern int tpmsg_free();
extern int tpmsg_enable();
extern int tpmsg_disable();
extern int tpmsg_change_message();
extern int tpslider_right_side();
extern int tpslider_bottom_side();
extern void tpslider_notify();
extern tpslider tpslider_new();
extern int tpslider_free();
extern int tpslider_get_val();
extern int tpslider_set_val();
extern int tpslider_set_min();
extern int tpslider_set_max();
extern int tpslider_enable();
extern int tpslider_disable();
extern int tpslider_set_event_procedure();
extern int tpstack_right_side();
extern int tpstack_bottom_side();
extern void tpstack_notify();
extern tpstack tpstack_new();
extern int tpstack_free();
extern int tpstack_enable();
extern int tpstack_disable();
extern int tpstack_add();
extern int tpstack_add_image();
extern char *tpstack_nth_string();
extern int tpstack_selected();
extern int tpstack_is_selected();
extern int tpstack_select_item();
extern int tpstack_unselect_item();
extern int tpstack_set_event_procedure();
extern int tptext_right_side();
extern int tptext_bottom_side();
extern tptext tptext_new();
extern tptext_set_displayed_characters();
extern int tptext_free();
extern char *tptext_get_val();
extern int tptext_set_val();
extern int tptext_enable();
extern int tptext_disable();
extern int tptext_set_event_procedure();
extern tptext_set_current();
extern tsave_show();
extern tsave_hide();
extern tsave_push_pin();
extern tsave_pull_pin();
extern tsave_change_filename();
extern int tsave_move();
extern int tsave_checkdir();
extern tsave_make_filelist();
extern return_file();
extern int tsave_choose_open();
extern int tsave_choose_up();
extern int tsave_choose_cancel();
extern int tsave_choose_dirname();
extern int tsave_choose_filename();
extern int tsave_choose_save();
extern int handle_save_frame();
extern int tsave_choose_filelist();
extern tsave tsave_new();
extern void *tsave_xview();
extern int tsave_get_panel();
extern int tsave_refit_panel();
extern int tsave_set_busy();
extern int tsave_set_notbusy();
extern int tskipspace();
extern int ttext_fit_line();
extern int ttext_char_at_pos();
extern int ttext_pos_of_char();
extern ttext_draw_chars();
extern show_selection();
extern int ttext_resize();
extern int ttext_move_immediately();
extern int ttext_move();
extern int ttext_repaint();
extern ttext_key();
extern int ttext_get_selection();
extern int ttext_set_selection();
extern int ttext_show_caret();
extern int ttext_hide_caret();
extern int ttext_handle_event();
extern int ttext_change_font();
extern int ttext_free();
extern ttext ttext_new();
extern ttext_set_color();
extern int ttext_insert_string();
extern int ttext_get_length();
extern char *ttext_get_string();
extern int pt_in_text();
extern int ttext_x();
extern int ttext_y();
extern int ttext_height();
extern int ttext_width();
extern char *ttext_get_selected_string();
extern int ttext_select();
extern int ttext_unselect();
extern int ttext_selected();
extern int ttext_delete_string();
extern ttext ttextcpy();
extern ttext_add_area();
